/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Name;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.encryption.IEncryptor;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.security.method.cms.encryption.PKCS7RecipientInfoEncoderECDH;
import de.intarsys.security.method.cms.encryption.PKCS7RecipientInfoEncoderRSA;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;

public abstract class CommonPKCS7RecipientInfoEncoder {
    public static CommonPKCS7RecipientInfoEncoder create(IX509PublicKeyCertificate recipientCertificate) {
        if (PpkTools.isSignatureAlgorithmECDSA((String)recipientCertificate.getPublicKey().getAlgorithm())) {
            return new PKCS7RecipientInfoEncoderECDH();
        }
        return new PKCS7RecipientInfoEncoderRSA();
    }

    protected CommonPKCS7RecipientInfoEncoder() {
    }

    protected abstract RecipientInfo basicEncode(byte[] var1, IEncryptor var2) throws EncryptorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipientInfo encode(byte[] cek, IX509PublicKeyCertificate certificate, IArgs args) throws EncryptorException {
        RecipientInfo recipientInfo;
        IDevice device = DeviceTools.detectDevice((IX509PublicKeyCertificate)certificate);
        args = args.copy();
        args.put("encryptorIdentifier", (Object)certificate);
        IEncryptor encryptor = (IEncryptor)device.createApplication(IEncryptor.class.getName(), args);
        try {
            recipientInfo = this.basicEncode(cek, encryptor);
        }
        catch (Throwable throwable) {
            try {
                encryptor.dispose();
                throw throwable;
            }
            catch (ObjectCreationException e) {
                throw new EncryptorException(e);
            }
        }
        encryptor.dispose();
        return recipientInfo;
    }

    protected IssuerAndSerialNumber encodeIssuerAndSerialNumber(IX509PublicKeyCertificate certificate) throws EncryptorException {
        Name issuerName;
        try {
            issuerName = (Name)Name.FACTORY.create((ASN1Encodable)ASN1Tools.create((byte[])certificate.getIssuerX500Principal().getEncoded()));
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
        CertificateSerialNumber serialNumber = CertificateSerialNumber.create((BigInteger)certificate.getSerialNumber());
        return IssuerAndSerialNumber.create((Name)issuerName, (CertificateSerialNumber)serialNumber);
    }
}

