/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.decryption;

import de.intarsys.asn1.cms.KeyAgreeRecipientInfo;
import de.intarsys.asn1.cms.KeyTransRecipientInfo;
import de.intarsys.asn1.cms.OriginatorIdentifierOrKey;
import de.intarsys.asn1.cms.OriginatorPublicKey;
import de.intarsys.asn1.cms.RecipientEncryptedKey;
import de.intarsys.asn1.cms.RecipientEncryptedKeys;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.EncryptedData;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.crypt.IKeyEncryptedData;
import de.intarsys.security.app.crypt.KeyEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricCryptHandlerRegistry;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricDecryptorException;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.bouncycastle.asn1.ASN1Encodable;

public class PKCS7RecipientInfoDecoder {
    protected byte[] basicDecodeKeyAgree(EncryptedData encryptedData, IDecryptor device) throws SecurityApplicationException {
        try {
            IDecryptedData decryptedKey = device.decrypt((IEncryptedData)encryptedData);
            return LocatorTools.getBytes((ILocator)decryptedKey.getLocator());
        }
        catch (IOException e) {
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
    }

    public byte[] decode(RecipientInfo recipientInfo, IDecryptor device) throws SecurityApplicationException, IOException {
        if (recipientInfo.isKeyTransRecipientInfo()) {
            return this.decodeRecipientInfo(recipientInfo.getKeyTransRecipientInfo(), device);
        }
        if (recipientInfo.isKeyAgreeRecipientInfo()) {
            return this.decodeRecipientInfo(recipientInfo.getKeyAgreeRecipientInfo(), device);
        }
        throw new SecurityApplicationException("RecipientInfo type not supported");
    }

    protected byte[] decodeRecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo, IDecryptor device) throws SecurityApplicationException {
        if (!keyAgreeRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm().startsWith("1.3.132.1.11")) {
            throw new SecurityApplicationException("Unsupported algorithm: " + keyAgreeRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm());
        }
        RecipientEncryptedKeys recipientEncryptedKeys = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
        if (recipientEncryptedKeys.size() == 0) {
            throw new SecurityApplicationException("No recipients.");
        }
        RecipientEncryptedKey recipientEncryptedKey = recipientEncryptedKeys.get(0);
        try {
            OriginatorIdentifierOrKey originatorIdentifierOrKey = keyAgreeRecipientInfo.getOriginator();
            EncryptedData ecdhInput = null;
            if (originatorIdentifierOrKey.isOriginatorKey()) {
                OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
                ecdhInput = new EncryptedData((ILocator)new ByteArrayLocator(originatorPublicKey.getPublicKey(), "temp", "unknown"), originatorPublicKey.getAlgorithm().getAlgorithm());
            } else {
                if (originatorIdentifierOrKey.isIssuerAndSerialNumber()) {
                    throw new SecurityApplicationException("IssuerAndSerial not supported");
                }
                if (originatorIdentifierOrKey.isSubjectKeyIdentifier()) {
                    throw new SecurityApplicationException("SubjectKeyIdentifier not supported");
                }
            }
            byte[] secret = this.basicDecodeKeyAgree(ecdhInput, device);
            String digestAlgorithm = SignatureAlgorithm.getHashAlgorithmName((String)keyAgreeRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm());
            IDigester digester = DigestTools.createDigester((String)digestAlgorithm);
            byte[] kek = digester.digest(secret).getBytes();
            AlgorithmIdentifier keyWrapAlgorithm = (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create((ASN1Encodable)keyAgreeRecipientInfo.getKeyEncryptionAlgorithm().getParameters());
            KeyEncryptedData encCek = new KeyEncryptedData((ILocator)new ByteArrayLocator(recipientEncryptedKey.getEncryptedKey().getBytes(), "unknown.bytes"), keyWrapAlgorithm.getAlgorithm(), kek);
            ISymmetricCryptHandler keyDecryptor = SymmetricCryptHandlerRegistry.get().lookupHandler(encCek.getAlgorithmOID());
            return keyDecryptor.decrypt((IKeyEncryptedData)encCek);
        }
        catch (IOException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (SymmetricDecryptorException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected byte[] decodeRecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo, IDecryptor device) throws SecurityApplicationException {
        ByteArrayLocator keyLocator = new ByteArrayLocator(keyTransRecipientInfo.getEncryptedKey().getBytes(), "temp", "unknown");
        EncryptedData encryptedKey = new EncryptedData((ILocator)keyLocator, keyTransRecipientInfo.getKeyEncryptionAlgorithmIdentifier().getAlgorithm());
        try {
            encryptedKey.setAlgorithmParameters(keyTransRecipientInfo.getKeyEncryptionAlgorithmIdentifier().getParametersEncoded());
            IDecryptedData decryptedKey = device.decrypt((IEncryptedData)encryptedKey);
            return LocatorTools.getBytes((ILocator)decryptedKey.getLocator());
        }
        catch (IOException e) {
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
    }
}

