/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.attr.AttributeSignaturePolicyIdentifier;
import de.intarsys.asn1.cms.attr.OtherHashAlgAndValue;
import de.intarsys.asn1.cms.attr.SigPolicyQualifierInfo;
import de.intarsys.asn1.cms.attr.SignaturePolicyId;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.policy.SignaturePolicy;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.policy.IImpliedPolicy;
import de.intarsys.security.signature.policy.IPolicy;
import de.intarsys.security.signature.policy.IPolicyId;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.IQualifier;
import de.intarsys.security.signature.policy.PolicyTools;
import de.intarsys.security.signature.policy.asn1.ASN1SignaturePolicy;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.util.Arrays;

public class SignaturePolicyIdentifierEncoder
implements IAttributeEncoder {
    private IPolicyReference policyReference;
    private String digestAlgorithm = "SHA-256";

    public SignaturePolicyIdentifierEncoder(IPolicyReference policyReference) {
        this.policyReference = policyReference;
    }

    protected IDigest calculateDigest(IPolicy policy) throws IOException {
        IDigester digester;
        byte[] digestInput = null;
        Object referenceDigest = null;
        if ("der".equals(policy.getEncoding())) {
            SignaturePolicy asn1Policy = this.getASN1Policy(policy);
            String definedHashAlgId = asn1Policy.getSignPolicyHashAlg().getAlgorithm();
            this.digestAlgorithm = SignatureAlgorithm.getHashAlgorithmName((String)definedHashAlgId);
            byte[] definedHashValue = asn1Policy.getSignPolicyHash();
            if (definedHashValue != null) {
                referenceDigest = DigestTools.createDigest((String)this.digestAlgorithm, (byte[])definedHashValue);
            }
            digestInput = Arrays.concatenate((byte[])asn1Policy.getSignPolicyHashAlg().getDEREncoded(), (byte[])asn1Policy.getSignPolicyInfo().getDEREncoded());
        }
        if (digestInput == null) {
            digestInput = policy.getEncoded();
        }
        try {
            digester = DigestTools.createDigester((String)this.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        IDigest digest = digester.digest(digestInput);
        if (referenceDigest != null && !referenceDigest.equals(digest)) {
            throw new IOException("Calculated hash value does not match the policy-internally defined hash value. Expected:" + (IDigest)referenceDigest + ", calculated: " + digest);
        }
        return digest;
    }

    protected SignaturePolicyId createSignaturePolicyId(IPolicyId policyId) throws IOException {
        SignaturePolicyId signaturePolicyId = (SignaturePolicyId)SignaturePolicyId.FACTORY.createNew();
        signaturePolicyId.setSigPolicyId(policyId.getOID());
        IPolicy policy = PolicyTools.lookupPolicy((IPolicyId)policyId);
        if (policy == null) {
            throw new IOException("Policy not available.");
        }
        IDigest digest = this.calculateDigest(policy);
        if (policyId.getDigest() != null && !policyId.getDigest().equals(digest)) {
            throw new IOException("Calculated hash value does not match the externally passed hash value. Expected:" + policyId.getDigest() + ", calculated: " + digest);
        }
        OtherHashAlgAndValue policyHash = (OtherHashAlgAndValue)OtherHashAlgAndValue.FACTORY.createNew();
        String algorithmOid = DigestAlgorithm.lookupOID((String)digest.getAlgorithmName());
        policyHash.setHashAlgorithm(AlgorithmIdentifier.create((String)algorithmOid));
        policyHash.setHashValue(digest.getBytes());
        signaturePolicyId.setSigPolicyHash(policyHash);
        for (IQualifier qualifier : policyId.getQualifiers()) {
            SigPolicyQualifierInfo sigPolicyQualifierInfo = (SigPolicyQualifierInfo)ASN1Tools.encodeObject((Object)qualifier);
            signaturePolicyId.addSigPolicyQualifierInfo(sigPolicyQualifierInfo);
        }
        return signaturePolicyId;
    }

    protected SignaturePolicy getASN1Policy(IPolicy policy) throws IOException {
        if (policy instanceof ASN1SignaturePolicy) {
            return ((ASN1SignaturePolicy)policy).getImpl();
        }
        ASN1Primitive asn1PolicyObject = ASN1Tools.create((byte[])policy.getEncoded());
        SignaturePolicy asn1Policy = (SignaturePolicy)SignaturePolicy.FACTORY.create((ASN1Encodable)asn1PolicyObject);
        return asn1Policy;
    }

    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) throws IOException {
        AttributeSignaturePolicyIdentifier signaturePolicyIdentifier = (AttributeSignaturePolicyIdentifier)AttributeSignaturePolicyIdentifier.FACTORY.createNew();
        if (this.getPolicyReference() instanceof IImpliedPolicy) {
            signaturePolicyIdentifier.addSignaturePolicyImplied();
        } else if (this.getPolicyReference() instanceof IPolicyId) {
            IPolicyId policyId = (IPolicyId)this.getPolicyReference();
            signaturePolicyIdentifier.addSignaturePolicyId(this.createSignaturePolicyId(policyId));
        }
        return signaturePolicyIdentifier;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public IPolicyReference getPolicyReference() {
        return this.policyReference;
    }

    @Override
    public boolean isToBeSigned() {
        return true;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }
}

