/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.security.method.cms.attribute.decoder.AttributeCertificatesDecoder;
import de.intarsys.security.method.cms.attribute.decoder.CertificateValuesDecoder;
import de.intarsys.security.method.cms.attribute.decoder.CommitmentTypeIndicationDecoder;
import de.intarsys.security.method.cms.attribute.decoder.OtherAttributeDecoder;
import de.intarsys.security.method.cms.attribute.decoder.RevocationInfoArchivalDecoder;
import de.intarsys.security.method.cms.attribute.decoder.RevocationValuesDecoder;
import de.intarsys.security.method.cms.attribute.decoder.SignaturePolicyIdentifierDecoder;
import de.intarsys.security.method.cms.attribute.decoder.SignatureTimestampDecoder;
import de.intarsys.security.method.cms.attribute.decoder.SignerAttributesDecoder;
import de.intarsys.security.method.cms.attribute.decoder.SignerAttributesV2Decoder;
import de.intarsys.security.method.cms.attribute.decoder.SigningCertificateV1Decoder;
import de.intarsys.security.method.cms.attribute.decoder.SigningCertificateV2Decoder;
import de.intarsys.security.method.cms.attribute.decoder.SigningTimeDecoder;
import de.intarsys.security.signature.attribute.AttributeCodecRegistry;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.tools.component.SingletonClass;

@SingletonClass
public class WellKnownAttributes {
    private static final WellKnownAttributes ACTIVE = new WellKnownAttributes();
    private final OtherAttributeDecoder defaultDecoder = new OtherAttributeDecoder();
    private final AttributeCodecRegistry registry = new AttributeCodecRegistry();

    public static WellKnownAttributes get() {
        return ACTIVE;
    }

    private WellKnownAttributes() {
        this.registerDecoder();
    }

    public IAttributeDecoder lookupDecoder(String attrType) {
        IAttributeDecoder decoder = this.registry.lookupDecoder(attrType);
        if (decoder == null) {
            decoder = this.defaultDecoder;
        }
        return decoder;
    }

    private void registerDecoder() {
        this.registerDecoder(new SignatureTimestampDecoder());
        this.registerDecoder(new SigningCertificateV1Decoder());
        this.registerDecoder(new SigningCertificateV2Decoder());
        this.registerDecoder(new CertificateValuesDecoder());
        this.registerDecoder(new RevocationValuesDecoder());
        this.registerDecoder(new RevocationInfoArchivalDecoder());
        this.registerDecoder(new SigningTimeDecoder());
        this.registerDecoder(new SignerAttributesDecoder());
        this.registerDecoder(new SignerAttributesV2Decoder());
        this.registerDecoder(new AttributeCertificatesDecoder());
        this.registerDecoder(new SignaturePolicyIdentifierDecoder());
        this.registerDecoder(new CommitmentTypeIndicationDecoder());
    }

    public void registerDecoder(IAttributeDecoder decoder) {
        this.registry.registerDecoder(decoder);
    }
}

