/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeSignaturePolicyIdentifier;
import de.intarsys.asn1.cms.attr.OtherHashAlgAndValue;
import de.intarsys.asn1.cms.attr.SigPolicyQualifierInfo;
import de.intarsys.asn1.cms.attr.SignaturePolicyId;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.ISignaturePolicyIdentifierAttribute;
import de.intarsys.security.signature.attribute.impl.SignaturePolicyIdentifierAttribute;
import de.intarsys.security.signature.policy.IPolicyId;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.IQualifier;
import de.intarsys.security.signature.policy.ImpliedPolicy;
import de.intarsys.security.signature.policy.PolicyId;
import de.intarsys.tools.digest.DigestTools;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class SignaturePolicyIdentifierDecoder
implements IAttributeDecoder {
    protected IPolicyId decode(SignaturePolicyId asn1PolicyId) throws IOException {
        PolicyId policyId = new PolicyId(asn1PolicyId.getSigPolicyId());
        OtherHashAlgAndValue sigPolicyHash = asn1PolicyId.getSigPolicyHash();
        String hashAlgOid = sigPolicyHash.getHashAlgorithm().getAlgorithm();
        DigestAlgorithm hashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgOid);
        byte[] hashValue = sigPolicyHash.getHashValue();
        policyId.setDigest(DigestTools.createDigest((String)hashAlgorithm.getName(), (byte[])hashValue));
        SigPolicyQualifierInfo[] asn1Qualifiers = asn1PolicyId.getSigPolicyQualifierInfos();
        if (asn1Qualifiers != null) {
            for (SigPolicyQualifierInfo asn1Qualifier : asn1Qualifiers) {
                IQualifier qualifier = this.decode(asn1Qualifier);
                if (qualifier == null) continue;
                policyId.addQualifier(qualifier);
            }
        }
        return policyId;
    }

    protected IQualifier decode(SigPolicyQualifierInfo asn1Qualifier) throws IOException {
        return (IQualifier)ASN1Tools.decodeObject((ASN1Encodable)asn1Qualifier, IQualifier.class);
    }

    public ISignaturePolicyIdentifierAttribute decodeAttribute(Object srcAttribute) throws IOException {
        ImpliedPolicy policyReference;
        Attribute cmsAttribute = (Attribute)srcAttribute;
        AttributeSignaturePolicyIdentifier attrSignaturePolicy = (AttributeSignaturePolicyIdentifier)AttributeSignaturePolicyIdentifier.FACTORY.create((ASN1Encodable)cmsAttribute);
        if (attrSignaturePolicy == null) {
            return null;
        }
        if (attrSignaturePolicy.hasImpliedPolicy()) {
            policyReference = ImpliedPolicy.INSTANCE;
        } else {
            SignaturePolicyId[] signaturePolicyIds = attrSignaturePolicy.getSignaturePolicyIdentifiers();
            if (signaturePolicyIds.length < 1) {
                return null;
            }
            policyReference = this.decode(signaturePolicyIds[0]);
        }
        return new SignaturePolicyIdentifierAttribute((IPolicyReference)policyReference);
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.15";
    }
}

