/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeSigningCertificate;
import de.intarsys.asn1.cms.attr.ESSCertID;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.ISigningCertificate;
import de.intarsys.security.signature.attribute.ISigningCertificateAttribute;
import de.intarsys.security.signature.attribute.impl.SigningCertificate;
import de.intarsys.security.signature.attribute.impl.SigningCertificateAttribute;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;

public abstract class CommonSigningCertificateDecoder
implements IAttributeDecoder {
    protected CommonSigningCertificateDecoder() {
    }

    private ISigningCertificateAttribute basicDecodeAttribute(Attribute cmsAttribute, List<ISigningCertificate> resultList) {
        AttributeSigningCertificate signingCert = (AttributeSigningCertificate)this.getFactory().create((ASN1Encodable)cmsAttribute);
        if (signingCert != null) {
            this.createSigningCertificates(signingCert.getSigningCertificates(), resultList);
        }
        if (resultList.size() > 0) {
            return new SigningCertificateAttribute(resultList.toArray(new ISigningCertificate[resultList.size()]));
        }
        return null;
    }

    protected void createSigningCertificates(List<de.intarsys.asn1.cms.attr.SigningCertificate> asnSigningCertificates, List<ISigningCertificate> resultList) {
        for (de.intarsys.asn1.cms.attr.SigningCertificate asnSigningCert : asnSigningCertificates) {
            if (asnSigningCert == null) continue;
            for (ESSCertID essCertId : asnSigningCert.getCerts()) {
                ISigningCertificate signingCert = this.getSigningCertificate(essCertId);
                if (signingCert == null) continue;
                resultList.add(signingCert);
            }
        }
    }

    public ISigningCertificateAttribute decodeAttribute(Object srcAttribute) throws IOException {
        Attribute cmsAttribute = (Attribute)srcAttribute;
        ArrayList<ISigningCertificate> resultList = new ArrayList<ISigningCertificate>();
        try {
            return this.basicDecodeAttribute(cmsAttribute, resultList);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Attribute 'SigningCertificateAttribute' could not be decoded", e);
        }
    }

    protected IDigest getDigest(ESSCertID essCertId) {
        String digestAlgo = essCertId.getHashAlgorithmOID();
        byte[] digestValue = essCertId.getCertHash();
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)digestAlgo);
        return DigestTools.createDigest((String)algorithm.getName(), (byte[])digestValue);
    }

    protected abstract ASN1Based.Factory getFactory();

    protected String getIssuerName(IssuerSerial issuerSerial) {
        X500Principal issuerPrincipal;
        try {
            issuerPrincipal = CertificateTools.parsePrincipal((GeneralNames)issuerSerial.getIssuer());
        }
        catch (IOException e) {
            return null;
        }
        if (issuerPrincipal != null) {
            return issuerPrincipal.toString();
        }
        return null;
    }

    protected ISigningCertificate getSigningCertificate(ESSCertID essCertId) {
        BigInteger serialNumber = null;
        String issuerName = null;
        IssuerSerial issuerSerial = essCertId.getIssuerSerial();
        if (issuerSerial != null) {
            serialNumber = issuerSerial.getSerial().getValue();
            issuerName = this.getIssuerName(issuerSerial);
        }
        IDigest digest = this.getDigest(essCertId);
        return new SigningCertificate(issuerName, serialNumber, digest);
    }
}

