/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeAttributeCertificates;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.attribute.X509V1AttributeCertificate;
import de.intarsys.security.signature.attribute.IAttributeCertificatesAttribute;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.impl.AttributeCertificatesAttribute;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;

public class AttributeCertificatesDecoder
implements IAttributeDecoder {
    public IAttributeCertificatesAttribute decodeAttribute(Object srcAttribute) throws IOException {
        Attribute cmsAttribute = (Attribute)srcAttribute;
        AttributeAttributeCertificates attrs = (AttributeAttributeCertificates)AttributeAttributeCertificates.FACTORY.create((ASN1Encodable)cmsAttribute);
        IX509AttributeCertificate[] attributeCertificates = this.getAttributeCertificates(attrs);
        return new AttributeCertificatesAttribute(attributeCertificates);
    }

    private IX509AttributeCertificate[] getAttributeCertificates(AttributeAttributeCertificates attrs) throws IOException {
        ArrayList<X509V1AttributeCertificate> result = new ArrayList<X509V1AttributeCertificate>();
        for (AttributeCertificate attributeCertificate : attrs.getAttributeCertificates()) {
            try {
                result.add(new X509V1AttributeCertificate(attributeCertificate));
            }
            catch (CertificateException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        return result.toArray(new IX509AttributeCertificate[result.size()]);
    }

    public String getOID() {
        return "2.5.4.58";
    }
}

