/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.asn1;

import de.intarsys.asn1.cms.attr.SigPolicyQualifierInfo;
import de.intarsys.asn1.model.IASN1Decoder;
import de.intarsys.security.method.cms.asn1.SigPolicyQualifierInfoURIDecoder;
import de.intarsys.security.method.cms.asn1.SigPolicyQualifierInfoUserNoticeDecoder;
import de.intarsys.security.signature.policy.IQualifier;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class SigPolicyQualifierInfoDecoder
implements IASN1Decoder<IQualifier, SigPolicyQualifierInfo> {
    public IQualifier decode(SigPolicyQualifierInfo object) throws IOException {
        String oid = object.getSigPolicyQualifierId();
        IASN1Decoder decoder = this.lookupDecoder(object, oid);
        if (decoder == null) {
            throw new IOException("No decoder available for SigPolicyQualifierInfo with oid " + oid);
        }
        return (IQualifier)decoder.decode((ASN1Encodable)object);
    }

    protected IASN1Decoder lookupDecoder(SigPolicyQualifierInfo object, String oid) {
        if ("1.2.840.113549.1.9.16.5.1".equals(oid)) {
            return new SigPolicyQualifierInfoURIDecoder();
        }
        if ("1.2.840.113549.1.9.16.5.2".equals(oid)) {
            return new SigPolicyQualifierInfoUserNoticeDecoder();
        }
        return null;
    }
}

