/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.sdk;

import ch.admin.suis.client.core.service.IValidationServiceClient;
import ch.admin.suis.client.core.service.ValidationServiceClientBuilder;
import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import de.intarsys.aaa.authenticate.impl.UserPasswordCredential;
import de.intarsys.egov.validationclient.sdk.EGovValidationServiceClient;
import de.intarsys.egov.validationclient.sdk.ObjectMapperContextResolver;
import de.intarsys.security.method.cms.common.CMSDecodersInstaller;
import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class EGovValidationServiceClientBuilder
extends ValidationServiceClientBuilder {
    private static final Logger Log = LoggerFactory.getLogger(EGovValidationServiceClientBuilder.class);
    private UserPasswordCredential credential;
    private UserPasswordCredential proxyCredential;
    private String serviceUrl;
    private SSLContext sslContext;
    private boolean wireLogging;
    private String proxyHost;
    private int proxyPort;

    public IValidationServiceClient build() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        ClientConfig config = new ClientConfig();
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        builder.withConfig((Configuration)config);
        String systemProxyHost = null;
        String systemProxyPort = null;
        try {
            String protocol = new URL(this.serviceUrl).getProtocol();
            systemProxyHost = System.getProperty(protocol + ".proxyHost");
            systemProxyPort = System.getProperty(protocol + ".proxyPort");
        }
        catch (MalformedURLException protocol) {
            // empty catch block
        }
        String actualProxyHost = this.proxyHost;
        if (StringTools.isEmpty((String)actualProxyHost)) {
            actualProxyHost = systemProxyHost;
        }
        if (!StringTools.isEmpty((String)actualProxyHost)) {
            String proxyUri = "http://" + actualProxyHost;
            int actualProxyPort = this.proxyPort;
            if (actualProxyPort == 0) {
                try {
                    actualProxyPort = Integer.parseInt(systemProxyPort);
                }
                catch (NumberFormatException ex) {
                    Log.warn(ex.getMessage(), (Throwable)ex);
                }
            }
            if (actualProxyPort != 0) {
                proxyUri = proxyUri + ":" + actualProxyPort;
            }
            builder.property("jersey.config.client.proxy.uri", (Object)proxyUri);
            if (this.proxyCredential != null) {
                try {
                    builder.property("jersey.config.client.proxy.username", (Object)this.proxyCredential.getQualifiedUserName());
                    builder.property("jersey.config.client.proxy.password", (Object)this.proxyCredential.getPassword().getString());
                }
                catch (GeneralSecurityException ex) {
                    Log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (this.sslContext != null) {
            builder.sslContext(this.sslContext);
        }
        Client client = (Client)((Client)builder.build().register(JacksonXmlBindJsonProvider.class)).register(ObjectMapperContextResolver.class);
        Level loggingLevel = this.wireLogging ? Level.INFO : Level.TRACE;
        WebTarget target = (WebTarget)client.target(this.serviceUrl).register((Object)new LoggingFeature(Log, loggingLevel, LoggingFeature.DEFAULT_VERBOSITY, Integer.valueOf(0x100000)));
        if (this.credential != null) {
            try {
                String password = this.credential.getPassword().getString();
                target.register((Object)HttpAuthenticationFeature.basic((String)this.credential.getQualifiedUserName(), (String)password));
            }
            catch (GeneralSecurityException ex) {
                Log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return new EGovValidationServiceClient(target);
    }

    public ValidationServiceClientBuilder credential(UserPasswordCredential credential) {
        this.credential = credential;
        return this;
    }

    public ValidationServiceClientBuilder proxyCredential(UserPasswordCredential proxyCredential) {
        this.proxyCredential = proxyCredential;
        return this;
    }

    public ValidationServiceClientBuilder proxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public ValidationServiceClientBuilder proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public ValidationServiceClientBuilder serviceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public ValidationServiceClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ValidationServiceClientBuilder wireLogging(boolean wireLogging) {
        this.wireLogging = wireLogging;
        return this;
    }

    static {
        new CMSDecodersInstaller().install();
    }
}

