/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.kdf;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Hkdf {
    private static final int MAX_LENGTH = 255;
    private static final String ALGORITHM = "HmacSHA256";
    private static final int LENGTH = 32;
    private SecretKey key;

    public Hkdf(byte[] salt, byte[] ikm) {
        this.key = this.extract(salt, ikm);
    }

    public byte[] expand(byte[] info, int outputLength) {
        if (outputLength < 1) {
            throw new IllegalArgumentException("outputLength must be positive");
        }
        int hashLen = 32;
        if (outputLength > 255 * hashLen) {
            throw new IllegalArgumentException("outputLength must be less than or equal to 255*HashLen");
        }
        int n = outputLength % hashLen == 0 ? outputLength / hashLen : outputLength / hashLen + 1;
        byte[] hashRound = new byte[]{};
        ByteBuffer generatedBytes = ByteBuffer.allocate(Math.multiplyExact(n, hashLen));
        Mac mac = this.initMac(this.key);
        for (int roundNum = 1; roundNum <= n; ++roundNum) {
            mac.reset();
            mac.update(hashRound);
            mac.update(info);
            mac.update((byte)roundNum);
            hashRound = mac.doFinal();
            generatedBytes.put(hashRound);
        }
        byte[] result = new byte[outputLength];
        generatedBytes.rewind();
        generatedBytes.get(result, 0, outputLength);
        return result;
    }

    private SecretKey extract(byte[] salt, byte[] ikm) {
        byte[] mySalt = salt;
        if (mySalt == null) {
            mySalt = new byte[32];
        }
        Mac mac = this.initMac(new SecretKeySpec(mySalt, ALGORITHM));
        byte[] keyBytes = mac.doFinal(ikm);
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }

    private Mac initMac(SecretKey key) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

