/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.app.validation.IValidationContextFactory;
import de.intarsys.security.app.validation.ValidationContextDecoratorRegistry;
import de.intarsys.security.app.validation.common.CommonValidationContextFactory;
import de.intarsys.security.app.validation.common.DecoratedValidationContextFactory;
import de.intarsys.security.app.validation.commonpki.CommonPKIValidationContextFactory;
import de.intarsys.security.app.validation.commonpki.crypto.CryptoValidationContextDecorator;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.QESValidationContextDecorator;
import de.intarsys.security.app.validation.commonpki.qes.QualificationSeverity;
import de.intarsys.security.app.validation.commonpki.qes.basic.QESBasicValidationContextDecorator;
import de.intarsys.security.app.validation.commonpki.qes.sigg.QESSigGValidationContextDecorator;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.common.CompositeCRLProvider;
import de.intarsys.security.standard.validation.commonpki.OCSPDepth;
import de.intarsys.security.standard.validation.ocsp.StandardOCSPCache;
import de.intarsys.security.validation.EnumOCSPCachingTime;
import de.intarsys.security.validation.PACKAGE;
import de.intarsys.security.validation.StageValidationContextFactory;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@SingletonProvider
public class ValidationEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static final Logger Log = LoggerFactory.getLogger(ValidationEnvironment.class);
    public static final String XE_CRLPROVIDER = "crlprovider";
    public static final String PREF_PRELOAD_CERTIFICATES = "preloadCertificates";
    public static final String XP_CRLPROVIDERS = "com.cabaret.security.crlproviders";
    public static final String PREF_VALIDATE_ON_DOC_OPEN = "validateOnDocOpen";
    public static final boolean DEFAULT_VALIDATE_ON_DOC_OPEN = true;
    public static final String PREF_VC_QUALIFICATION_SEVERITY = "qualificationSeverity";
    public static final String PREF_VC_QUALIFICATION_PROFILE = "qualificationProfile";
    public static final String PREF_OCSP_CACHING_TIME = "ocspCachingTime";
    public static final String PREF_VC_CHECK_CRL = "checkCRL";
    public static final String PREF_VC_CHECK_OCSP = "checkOCSP";
    public static final String PREF_VC_OCSP_DEPTH = "ocspDepth";
    public static final String PREF_VC_OCSP_WARN_ON_NO_URL = "ocspWarnOnNoURL";
    public static final String PREF_VC_OCSP_DEFAULT_ACCEPT_PERIOD = "ocspDefaultAcceptPeriod";
    public static final String PREF_VC_HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final String PREF_VC_HTTP_READ_TIMEOUT = "httpReadTimeout";
    public static final String PREF_VALIDATION_TIMEOUT = "validationTimeout";
    public static final String PREF_VALIDATION_THREAD_COUNT = "validationThreadCount";
    private static IMessageBundle Msg = PACKAGE.Messages;
    private ICRLProvider crlProvider;
    private boolean preloadCertificates;
    private List<ICRLProvider> crlProviders;
    private StandardOCSPCache ocspCache;
    private Duration defaultValidationTimeout = Duration.ofMinutes(3L);
    private final IExtensionPointHandler crlProviderInstaller = new ExtensionPointHandlerAdapter(){

        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (ValidationEnvironment.XE_CRLPROVIDER.equals(element.getName())) {
                try {
                    ICRLProvider provider = (ICRLProvider)ElementTools.createObject((IElement)element, ICRLProvider.class, (Object)extension.getProvider(), (IArgs)Args.create());
                    ValidationEnvironment.this.crlProviders.add(provider);
                }
                catch (ObjectCreationException e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            } else {
                return super.basicInstallInsert(extension, element);
            }
            return null;
        }
    };
    private IPreferences preferences;
    private ExecutorService executor;
    private int executorPoolSize = 5;
    private IValidationContextFactory validationContextFactory;

    public static ValidationEnvironment get() {
        return (ValidationEnvironment)ServiceLocator.get().get(ValidationEnvironment.class);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public CommonPKIProfile getCommonPKIProfile() {
        return (CommonPKIProfile)CommonPKIProfile.META.getItemOrDefault(this.getQualificationProfile());
    }

    public synchronized ICRLProvider getCRLProvider() {
        if (this.crlProvider == null) {
            this.crlProvider = new CompositeCRLProvider(this.getCRLProviders());
        }
        return this.crlProvider;
    }

    protected List<ICRLProvider> getCRLProviders() {
        if (this.crlProviders == null) {
            this.crlProviders = new ArrayList<ICRLProvider>();
            try {
                InstrumentTools.installExtensions((IInstrumentRegistry)InstrumentRegistry.get(), (String)XP_CRLPROVIDERS, (IExtensionPointHandler)this.crlProviderInstaller);
            }
            catch (InstrumentRegistryException e) {
                Log.warn("error registering extension point 'com.cabaret.security.crlproviders'");
            }
        }
        return this.crlProviders;
    }

    public Duration getDefaultValidationTimeout() {
        return this.defaultValidationTimeout;
    }

    public int getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public ExecutorService getExecutorService() {
        if (this.executor == null) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(this.getExecutorPoolSize(), this.getExecutorPoolSize(), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadTools.newThreadFactoryDaemon((String)"validation executor"));
            executor.allowCoreThreadTimeOut(true);
            this.executor = executor;
        }
        return this.executor;
    }

    public synchronized StandardOCSPCache getOcspCache() {
        if (this.ocspCache == null) {
            this.ocspCache = new StandardOCSPCache();
            this.ocspCache.setMaxCachingTime(this.getOCSPCachingTime().getValue());
        }
        return this.ocspCache;
    }

    public EnumOCSPCachingTime getOCSPCachingTime() {
        String id = this.getPreferences().get(PREF_OCSP_CACHING_TIME);
        return (EnumOCSPCachingTime)EnumOCSPCachingTime.META.getItemOrDefault(id);
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.digsig/validation";
    }

    @Deprecated
    public String getQualificationProfile() {
        return this.getValidationContextPreferences().get(PREF_VC_QUALIFICATION_PROFILE);
    }

    public String getQualificationSeverity() {
        return this.getValidationContextPreferences().get(PREF_VC_QUALIFICATION_SEVERITY);
    }

    public IValidationContextFactory getValidationContextFactory() {
        return this.validationContextFactory;
    }

    public IPreferences getValidationContextPreferences() {
        return this.getPreferences().node("validationContext");
    }

    @PostConstruct
    public void install() {
        CommonValidationContextFactory contextFactory = CommonPKIValidationContextFactory.get();
        contextFactory = new DecoratedValidationContextFactory(contextFactory);
        contextFactory = new StageValidationContextFactory(contextFactory);
        this.setValidationContextFactory(contextFactory);
        ValidationContextDecoratorRegistry.get().registerDecorator("Crypto", new CryptoValidationContextDecorator());
        ValidationContextDecoratorRegistry.get().registerDecorator("QES", new QESValidationContextDecorator());
        ValidationContextDecoratorRegistry.get().registerDecorator("QES_Basic", new QESBasicValidationContextDecorator());
        ValidationContextDecoratorRegistry.get().registerDecorator("QES_SigG", new QESSigGValidationContextDecorator());
        this.getOcspCache().start();
        this.preferencesRestore();
    }

    public boolean isPreloadCertificates() {
        return this.preloadCertificates;
    }

    public boolean isValidateOnDocOpen() {
        return this.getPreferences().getBoolean(PREF_VALIDATE_ON_DOC_OPEN, true);
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.putBoolean(PREF_PRELOAD_CERTIFICATES, true);
        preferences.putBoolean(PREF_VALIDATE_ON_DOC_OPEN, true);
        preferences.put(PREF_OCSP_CACHING_TIME, EnumOCSPCachingTime.META.getDefault().getId());
        preferences.put(PREF_VALIDATION_THREAD_COUNT, 5);
        preferences.put(PREF_VALIDATION_TIMEOUT, 180000L);
        IPreferences pValidationContext = preferences.node("validationContext");
        pValidationContext.put(PREF_VC_QUALIFICATION_SEVERITY, QualificationSeverity.META.getDefault().getId());
        pValidationContext.put(PREF_VC_QUALIFICATION_PROFILE, ((CommonPKIProfile)CommonPKIProfile.META.getDefault()).getId());
        pValidationContext.put(PREF_VC_CHECK_OCSP, true);
        pValidationContext.put(PREF_VC_CHECK_CRL, true);
        pValidationContext.put(PREF_VC_OCSP_DEPTH, ((OCSPDepth)OCSPDepth.META.getDefault()).getId());
        pValidationContext.put(PREF_VC_OCSP_WARN_ON_NO_URL, false);
        pValidationContext.put(PREF_VC_HTTP_CONNECT_TIMEOUT, 5000);
        pValidationContext.put(PREF_VC_OCSP_DEFAULT_ACCEPT_PERIOD, 10000);
        pValidationContext.put(PREF_VC_HTTP_READ_TIMEOUT, 15000);
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        this.preloadCertificates = preferences.getBoolean(PREF_PRELOAD_CERTIFICATES, true);
        this.executorPoolSize = preferences.getInt(PREF_VALIDATION_THREAD_COUNT, this.getExecutorPoolSize());
        long timeoutMillis = preferences.getLong(PREF_VALIDATION_TIMEOUT, this.getDefaultValidationTimeout().toMillis());
        this.defaultValidationTimeout = Duration.ofMillis(timeoutMillis);
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        preferences.put(PREF_PRELOAD_CERTIFICATES, this.isPreloadCertificates());
        preferences.put(PREF_VALIDATION_THREAD_COUNT, this.getExecutorPoolSize());
        preferences.put(PREF_VALIDATION_TIMEOUT, this.getDefaultValidationTimeout().toMillis());
    }

    public void setCRLProvider(ICRLProvider crlProvider) {
        this.crlProvider = crlProvider;
    }

    public void setDefaultValidationTimeout(Duration defaultValidationTimeout) {
        this.defaultValidationTimeout = defaultValidationTimeout;
    }

    public void setExecutorPoolSize(int executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
    }

    public void setOCSPCachingTime(EnumOCSPCachingTime ocspCachingTime) {
        this.getPreferences().put(PREF_OCSP_CACHING_TIME, ocspCachingTime.getId());
        if (this.ocspCache != null) {
            this.ocspCache.setMaxCachingTime(this.getOCSPCachingTime().getValue());
        }
    }

    public void setPreloadCertificates(boolean preloadCertificates) {
        this.preloadCertificates = preloadCertificates;
    }

    public void setQualificationSeverity(String value) {
        this.getValidationContextPreferences().put(PREF_VC_QUALIFICATION_SEVERITY, value);
    }

    public void setValidationContextFactory(IValidationContextFactory validationContextFactory) {
        this.validationContextFactory = validationContextFactory;
    }

    @PreDestroy
    public void uninstall() {
        this.preferencesStore();
        this.getOcspCache().stop();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

