/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.app.validation.ICertificatePathBuilder;
import de.intarsys.security.app.validation.ICertificatePathValidator;
import de.intarsys.security.app.validation.ICertificateValidator;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.ITimestampValidator;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationContextFactory;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.common.ValidationContextFactoryProxy;
import de.intarsys.security.app.validation.commonpki.ValidationContextProxy;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.standard.AdditionalCertificateProvider;
import de.intarsys.security.certificate.provider.standard.TrustedCertificateProvider;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.common.CompositeCRLProvider;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public class InfrastructureValidationContextFactoryProxy
extends ValidationContextFactoryProxy {
    private static final Attribute ATTR_EXTENDED = new Attribute(InfrastructureValidationContextFactoryProxy.class + ".extended");
    private static final Attribute STATEATTR_ARGUMENTS = new Attribute("arguments");

    public static IValidationParameters extendValidationParameters(IValidationParameters basicParams) {
        ICRLProvider crlProvider;
        Boolean extended;
        if (basicParams instanceof IAttributeSupport && (extended = (Boolean)basicParams.getAttribute(ATTR_EXTENDED)) != null && extended.booleanValue()) {
            return basicParams;
        }
        ValidationParameters parameters = ValidationParameters.copy(basicParams);
        CompositeCertificateProvider additionalCertificates = new CompositeCertificateProvider();
        additionalCertificates.registerCertificateProvider(AdditionalCertificateProvider.get());
        additionalCertificates.registerCertificateProvider(parameters.getAdditionalCerts());
        parameters.setAdditionalCerts(additionalCertificates);
        CompositeCertificateProvider trustedCertificates = new CompositeCertificateProvider();
        trustedCertificates.registerCertificateProvider(TrustedCertificateProvider.get());
        trustedCertificates.registerCertificateProvider(parameters.getTrustedCerts());
        parameters.setTrustedCerts(trustedCertificates);
        ICRLProvider globalProvider = ValidationEnvironment.get().getCRLProvider();
        ICRLProvider paramProvider = parameters.getCRLProvider();
        if (paramProvider == null) {
            crlProvider = globalProvider;
        } else if (globalProvider != null && globalProvider != paramProvider) {
            CompositeCRLProvider compositeProvider = new CompositeCRLProvider();
            compositeProvider.addDelegateProvider(paramProvider);
            compositeProvider.addDelegateProvider(globalProvider);
            crlProvider = compositeProvider;
        } else {
            crlProvider = paramProvider;
        }
        parameters.setCRLProvider(crlProvider);
        parameters.setAttribute(ATTR_EXTENDED, true);
        return parameters;
    }

    public static IArgs getArgs(IValidationState state) {
        IArgs args = (IArgs)state.getAttribute(STATEATTR_ARGUMENTS);
        if (args == null) {
            args = Args.create();
        }
        return args;
    }

    public static void setArgs(IValidationState state, IArgs args) {
        state.setAttribute(STATEATTR_ARGUMENTS, args);
    }

    public InfrastructureValidationContextFactoryProxy(IValidationContextFactory basicValidationContextFactory) {
        super(basicValidationContextFactory);
    }

    @Override
    protected IValidationContext basicCreateValidationContext(IArgs args) {
        IArgs localArgs = this.createValidationContextArgs(args);
        IValidationContext basicValidationContext = this.createBasicValidationContext(localArgs);
        ValidationContextProxy myContext = new ValidationContextProxy(basicValidationContext);
        myContext.setSignatureContainerValidator(new SignatureContainerValidator(basicValidationContext.getSignatureContainerValidator()));
        myContext.setTimestampValidator(new TimestampValidator(basicValidationContext.getTimestampValidator()));
        myContext.setCertificateValidator(new CertificateValidator(basicValidationContext.getCertificateValidator()));
        myContext.setCertificatePathBuilder(new CertificatePathBuilder(basicValidationContext.getCertificatePathBuilder()));
        myContext.setCertificatePathValidator(new CertificatePathValidator(basicValidationContext.getCertificatePathValidator()));
        return myContext;
    }

    protected IArgs createValidationContextArgs(IArgs externalArgs) {
        return externalArgs;
    }

    private static class SignatureContainerValidator
    implements ISignatureContainerValidator {
        private final ISignatureContainerValidator basicValidator;

        public SignatureContainerValidator(ISignatureContainerValidator basicValidator) {
            this.basicValidator = basicValidator;
        }

        public IVSSignatureContainer validate(ISignatureContainer signatureContainer, IDigest digest, IValidationParameters parameters) {
            IVSSignatureContainer state = this.basicValidator.validate(signatureContainer, digest, parameters);
            InfrastructureValidationContextFactoryProxy.setArgs(state, ValidationContext.get().getArgs());
            return state;
        }
    }

    private static class TimestampValidator
    implements ITimestampValidator {
        private final ITimestampValidator basicValidator;

        public TimestampValidator(ITimestampValidator basicValidator) {
            this.basicValidator = basicValidator;
        }

        @Override
        public IVSTimestamp validate(ITimestampToken timestamp, IDigest digest, IValidationParameters parameters) {
            IVSTimestamp state = this.basicValidator.validate(timestamp, digest, parameters);
            InfrastructureValidationContextFactoryProxy.setArgs(state, ValidationContext.get().getArgs());
            return state;
        }
    }

    private static class CertificateValidator
    implements ICertificateValidator {
        private final ICertificateValidator basicValidator;

        public CertificateValidator(ICertificateValidator basicValidator) {
            this.basicValidator = basicValidator;
        }

        @Override
        public IVSCertificate validate(IX509Certificate certificate, IValidationParameters parameters) {
            parameters = InfrastructureValidationContextFactoryProxy.extendValidationParameters(parameters);
            IVSCertificate state = this.basicValidator.validate(certificate, parameters);
            InfrastructureValidationContextFactoryProxy.setArgs(state, ValidationContext.get().getArgs());
            return state;
        }
    }

    private static class CertificatePathBuilder
    implements ICertificatePathBuilder {
        private final ICertificatePathBuilder basicBuilder;

        public CertificatePathBuilder(ICertificatePathBuilder basicBuilder) {
            this.basicBuilder = basicBuilder;
        }

        @Override
        public IVSCertificatePath buildCertificatePath(IX509Certificate certificate, IValidationParameters parameters) {
            parameters = InfrastructureValidationContextFactoryProxy.extendValidationParameters(parameters);
            IVSCertificatePath state = this.basicBuilder.buildCertificatePath(certificate, parameters);
            return state;
        }
    }

    private static class CertificatePathValidator
    implements ICertificatePathValidator {
        private final ICertificatePathValidator basicValidator;

        public CertificatePathValidator(ICertificatePathValidator basicValidator) {
            this.basicValidator = basicValidator;
        }

        @Override
        public IVSCertificatePath validateCertificatePath(IX509CertificatePath certPath, IValidationParameters parameters) {
            parameters = InfrastructureValidationContextFactoryProxy.extendValidationParameters(parameters);
            IVSCertificatePath state = this.basicValidator.validateCertificatePath(certPath, parameters);
            InfrastructureValidationContextFactoryProxy.setArgs(state, ValidationContext.get().getArgs());
            return state;
        }
    }
}

