/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.validation.IExtendedValidationData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class ExtendedValidationData
implements IExtendedValidationData {
    private final Collection<IX509CRL> crls;
    private final Collection<IOCSPResponse> ocsps;
    private final Collection<IX509PublicKeyCertificate> certificates;

    public ExtendedValidationData(IX509CRL[] crls, IOCSPResponse[] ocsps, IX509PublicKeyCertificate[] certificates) {
        this(List.of(crls), List.of(ocsps), List.of(certificates));
    }

    public ExtendedValidationData(Collection<IX509CRL> crls, Collection<IOCSPResponse> ocsps, Collection<IX509PublicKeyCertificate> certificates) {
        this.crls = crls;
        this.ocsps = ocsps;
        this.certificates = certificates;
    }

    @Override
    public Stream<IX509CRL> getCRLs() {
        return this.crls.stream();
    }

    @Override
    public Stream<IOCSPResponse> getOCSPResponses() {
        return this.ocsps.stream();
    }

    @Override
    public Stream<IX509PublicKeyCertificate> getCertificates() {
        return this.certificates.stream();
    }
}

