/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerChain
implements X509TrustManager {
    private static final Logger Log = LoggerFactory.getLogger(TrustManagerChain.class);
    private List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();

    public void addTrustManager(X509TrustManager trustManager) {
        this.trustManagers.add(trustManager);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] path, String authType) throws CertificateException {
        CertificateException ex = null;
        for (X509TrustManager trustManager : this.getTrustManagers()) {
            try {
                trustManager.checkClientTrusted(path, authType);
                return;
            }
            catch (CertificateException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        throw ex;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] path, String authType) throws CertificateException {
        CertificateException ex = null;
        for (X509TrustManager trustManager : this.getTrustManagers()) {
            try {
                trustManager.checkServerTrusted(path, authType);
                return;
            }
            catch (CertificateException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        throw ex;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])this.getTrustManagers().stream().flatMap(tm -> Stream.of(tm.getAcceptedIssuers())).toArray(X509Certificate[]::new);
    }

    public List<X509TrustManager> getTrustManagers() {
        return new ArrayList<X509TrustManager>(this.trustManagers);
    }
}

