/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ssl;

import de.intarsys.security.ssl.TrustManagerBuilder;
import de.intarsys.tools.ssl.ITrustManagerProvider;
import java.security.GeneralSecurityException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class CommonTrustManagerProvider
implements ITrustManagerProvider {
    private X509TrustManager trustManager;
    private boolean includeDefault = true;

    protected CommonTrustManagerProvider() {
    }

    protected abstract X509TrustManager basicCreateTrustManager() throws GeneralSecurityException;

    protected X509TrustManager createTrustManager() throws GeneralSecurityException {
        if (this.trustManager == null) {
            TrustManagerBuilder builder = TrustManagerBuilder.get();
            if (this.isIncludeDefault()) {
                builder.addDefault();
            }
            builder.add(this.basicCreateTrustManager());
            this.trustManager = builder.build();
        }
        return this.trustManager;
    }

    public TrustManager[] createTrustManagers() throws GeneralSecurityException {
        return new TrustManager[]{this.createTrustManager()};
    }

    public boolean isIncludeDefault() {
        return this.includeDefault;
    }

    public void setIncludeDefault(boolean includeDefault) {
        this.includeDefault = includeDefault;
    }
}

