/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.common.TimestampEntryDefaultStateFactory;
import de.intarsys.security.app.validation.pkcs1.EncodedSignatureEntryValidator;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.signature.EncodedSignature;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.attribute.EmptyAttributeMap;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EncodedSignatureEntry
implements ISignatureEntry,
IAdapterSupport {
    private final EncodedSignature signatureContainer;

    protected EncodedSignatureEntry(EncodedSignature signatureContainer) {
        this.signatureContainer = signatureContainer;
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureEntryValidator.class) {
            return (T)new EncodedSignatureEntryValidator();
        }
        if (clazz == ISignatureContainerEntryDefaultStateFactory.class) {
            return (T)new TimestampEntryDefaultStateFactory();
        }
        return null;
    }

    @Override
    public List<IX509PublicKeyCertificate> getAdditionalCertificates() throws CertificateException, IOException {
        ArrayList<IX509PublicKeyCertificate> additional = new ArrayList<IX509PublicKeyCertificate>(this.signatureContainer.getCertificates());
        additional.remove(0);
        return additional;
    }

    public Object getAttribute(Object key) {
        return this.signatureContainer.getAttribute(key);
    }

    @Override
    public String getContentType() {
        return this.signatureContainer.getContentType();
    }

    @Override
    public Date getCreationDate() {
        return this.getSigningTime();
    }

    @Override
    public AlgorithmSpec<DigestAlgorithm> getHashAlgorithmSpec() {
        return this.signatureContainer.getHashAlgorithmSpec();
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public AlgorithmSpec<SignatureAlgorithm> getSignatureAlgorithmSpec() {
        return this.signatureContainer.getSignatureAlgorithmSpec();
    }

    @Override
    public EncodedSignature getSignatureContainer() {
        return this.signatureContainer;
    }

    @Override
    public byte[] getSignatureEncoded() {
        return this.signatureContainer.getBytes();
    }

    @Override
    public IAttributeMap getSignedAttributes() {
        return EmptyAttributeMap.INSTANCE;
    }

    public IDigest getSignedContentDigest() {
        return null;
    }

    @Override
    public IX509PublicKeyCertificate getSignerCertificate() throws CertificateException, IOException {
        return this.signatureContainer.getSignerCertificate();
    }

    @Override
    public Date getSigningTime() {
        return null;
    }

    @Override
    public byte[] getTimestampInput() {
        return this.signatureContainer.getBytes();
    }

    @Override
    public IAttributeMap getUnsignedAttributes() {
        return EmptyAttributeMap.INSTANCE;
    }

    public Object removeAttribute(Object key) {
        return this.signatureContainer.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.signatureContainer.setAttribute(key, value);
    }
}

