/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.privatekey;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.PrivateKeyProviderTools;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordValidator;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.UnrecoverableKeyException;

public class PrivateKeyPasswordVerifier
implements IPasswordValidator {
    private IPrivateKeyProvider keyProvider;
    private IX509PublicKeyCertificate certificate;

    public PrivateKeyPasswordVerifier(IX509PublicKeyCertificate certificate) {
        this.certificate = certificate;
        this.keyProvider = PrivateKeyProviderTools.getKeyProvider(certificate);
        if (certificate == null) {
            throw new IllegalArgumentException("IX509PublicKeyCertificate must not be null");
        }
        if (this.keyProvider == null) {
            throw new IllegalArgumentException("No key available.");
        }
    }

    public PrivateKeyPasswordVerifier(IX509PublicKeyCertificate certificate, IPrivateKeyProvider keyProvider) {
        if (certificate == null) {
            throw new IllegalArgumentException("IX509PublicKeyCertificate must not be null");
        }
        this.certificate = certificate;
        this.keyProvider = keyProvider;
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public IPrivateKeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    public boolean isValid(Secret password) throws IOException {
        try {
            this.getKeyProvider().getPrivateKey(this.getCertificate(), (IPasswordProvider)new ConstantPasswordProvider(password));
            return true;
        }
        catch (UnrecoverableKeyException e) {
            return false;
        }
    }
}

