/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class X509ExtensionSubjectKeyIdentifier
extends CommonX509Extension {
    public static final String OID = "2.5.29.14";
    private PublicKey publicKey;

    public static X509ExtensionSubjectKeyIdentifier create(byte[] encoded) throws IOException {
        SubjectKeyIdentifier aki = SubjectKeyIdentifier.getInstance((Object)ASN1Tools.create((byte[])encoded));
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(aki.getEncoded("DER"));
            RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(keySpecX509);
            return new X509ExtensionSubjectKeyIdentifier(pubKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    public X509ExtensionSubjectKeyIdentifier() {
    }

    public X509ExtensionSubjectKeyIdentifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getOid() {
        return OID;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getValue() throws IOException {
        if (this.getPublicKey() == null) {
            return null;
        }
        try {
            SubjectKeyIdentifier subjectKeyIdentifier = new JcaX509ExtensionUtils().createSubjectKeyIdentifier(this.getPublicKey());
            return subjectKeyIdentifier.getEncoded("DER");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }
}

