/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class X509ExtensionSubjectAltNames
extends CommonX509Extension {
    public static final String OID = "2.5.29.17";
    private final List<GeneralName> names;

    public static X509ExtensionSubjectAltNames create(byte[] encoded) throws IOException {
        GeneralNames names = GeneralNames.getInstance((Object)ASN1Tools.create((byte[])encoded));
        return new X509ExtensionSubjectAltNames(new ArrayList<GeneralName>(Arrays.asList(names.getNames())));
    }

    public X509ExtensionSubjectAltNames() {
        this(new ArrayList<GeneralName>());
    }

    public X509ExtensionSubjectAltNames(List<GeneralName> names) {
        this.names = names;
    }

    public void addName(int tag, String value) {
        this.getNames().add(new GeneralName(tag, value));
    }

    public GeneralName getName(int tag) {
        for (GeneralName name : this.getNames()) {
            if (name.getTagNo() != tag) continue;
            return name;
        }
        return null;
    }

    public List<GeneralName> getNames() {
        return this.names;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public byte[] getValue() throws IOException {
        GeneralNames names = new GeneralNames(this.getNames().toArray(new GeneralName[this.getNames().size()]));
        return names.getEncoded();
    }

    public void removeName(int tag) {
        for (GeneralName name : new ArrayList<GeneralName>(this.getNames())) {
            if (name.getTagNo() != tag) continue;
            this.names.remove(name);
        }
    }
}

