/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;

public class SubjectKeyIdentifierHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("SubjectKeyIdentifierHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.14";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        SubjectKeyIdentifier id = SubjectKeyIdentifier.getInstance((Object)value);
        if (id == null) {
            return null;
        }
        byte[] keyId = id.getKeyIdentifier();
        StringBuilder sb = new StringBuilder();
        if (keyId != null) {
            sb.append("KeyIdentifier: #").append(HexTools.bytesToHexString((byte[])keyId)).append(StringTools.LS);
        }
        return sb.toString();
    }
}

