/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CompositeCRLProvider;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IOriginProvider;
import de.intarsys.security.validation.Origin;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class EmbeddedCRLProvider
extends CompositeCRLProvider
implements IOriginProvider<IX509CRL> {
    private Set<IX509CRL> crls = new HashSet<IX509CRL>();

    public void addCRL(IX509CRL crl) {
        this.crls.add(crl);
    }

    @Override
    protected Stream<IX509CRL> basicLookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        Date referenceDate = selector.getDateAndTime();
        return CrlTools.selectCRLs(selector, this.getCRLs().stream()).filter(crl -> this.testReferenceDate((IX509CRL)crl, referenceDate)).peek(CrlTools.attachProvider(this));
    }

    public Set<IX509CRL> getCRLs() {
        return new HashSet<IX509CRL>(this.crls);
    }

    @Override
    public IOrigin getOrigin(IX509CRL element) {
        return Origin.embedded();
    }

    protected boolean testReferenceDate(IX509CRL crl, Date referenceDate) {
        if (referenceDate == null || crl.getNextUpdate() == null) {
            return true;
        }
        return referenceDate.before(crl.getNextUpdate());
    }
}

