/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.crl.ICRL;
import de.intarsys.security.crl.ICRLContainer;
import de.intarsys.security.crl.common.CRL;
import de.intarsys.security.crl.common.Permissions;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.infoset.DocumentTools;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLContainer
implements ICRLContainer {
    private static final String NAME_CONFIG_FILE = "container.xml";
    private static final String ELEM_CONTAINER = "container";
    private static final String ELEM_PERMISSIONS = "permissions";
    private static final Logger Log = LoggerFactory.getLogger(CRLContainer.class);
    private List crls = new ArrayList();
    private Permissions permissions;
    private ILocator locator;

    public static CRLContainer createFromLocator(ILocator locator) throws IOException {
        CRLContainer container = new CRLContainer(locator);
        container.load();
        return container;
    }

    public static CRLContainer createNew(ILocator locator) {
        return new CRLContainer(locator);
    }

    protected CRLContainer(ILocator locator) {
        this.locator = locator;
    }

    @Override
    public boolean containsCRL(ICRL crl) {
        if (crl == null) {
            return false;
        }
        for (ICRL current : this.crls) {
            if (current != crl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsName(String name) {
        return this.getCRL(name) != null;
    }

    @Override
    public ICRL createCRL(String name) {
        if (name == null) {
            name = "default";
            Object newName = name;
            int i = 1;
            while (this.containsName((String)newName)) {
                newName = name + "(" + i + ")";
                ++i;
            }
            name = newName;
        }
        String dirName = FileTools.trimPath((String)name);
        ILocator crlLocator = this.getLocator().getChild(dirName);
        CRL crl = CRL.createNew(crlLocator);
        crl.setName(name);
        this.crls.add(crl);
        return crl;
    }

    protected ILocator getConfigFile() {
        return this.getLocator().getChild(NAME_CONFIG_FILE);
    }

    @Override
    public ICRL getCRL(String name) {
        if (name == null) {
            return null;
        }
        for (ICRL crl : this.getCRLs()) {
            if (!name.equals(crl.getName())) continue;
            return crl;
        }
        return null;
    }

    @Override
    public List getCRLs() {
        return new ArrayList(this.crls);
    }

    public ILocator getLocator() {
        return this.locator;
    }

    protected Permissions getPermissions() {
        if (this.permissions == null) {
            this.permissions = new Permissions();
        }
        return this.permissions;
    }

    @Override
    public boolean hasPermissionModify() {
        return this.getPermissions().isPermitted("modify", true);
    }

    @Override
    public boolean hasPermissionUpdate() {
        return this.getPermissions().isPermitted("update", true);
    }

    protected void load() throws IOException {
        this.loadConfig();
        this.loadCRLs();
    }

    protected void loadConfig() throws IOException {
        ILocator configFile = this.getConfigFile();
        if (!configFile.exists() || configFile.isDirectory()) {
            return;
        }
        IDocument doc = DocumentTools.parse((ILocator)configFile);
        IElement eRoot = doc.getRootElement();
        IElement ePermissions = eRoot.element(ELEM_PERMISSIONS);
        if (ePermissions != null) {
            this.permissions = Permissions.parse(ePermissions);
        }
    }

    protected void loadCRLs() throws IOException {
        ILocator[] children = this.locator.listLocators(new ILocatorNameFilter(){

            public boolean accept(ILocator parent, String name) {
                return parent.getChild(name).isDirectory();
            }
        });
        for (int i = 0; i < children.length; ++i) {
            ILocator child = children[i];
            try {
                CRL crl = CRL.createFromLocator(child);
                this.crls.add(crl);
                continue;
            }
            catch (Exception e) {
                Log.info("can't load '" + child.getPath() + "' (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void removeCRL(ICRL crl) {
        if (!this.containsCRL(crl)) {
            return;
        }
        this.crls.remove(crl);
        try {
            ((CRL)crl).getLocator().delete();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            Log.warn("failed to delete CRL {}", (Object)((CRL)crl).getLocator(), (Object)e);
        }
    }

    @Override
    public void save() throws IOException {
        this.saveConfig();
        this.saveCRLs();
    }

    protected void saveConfig() throws IOException {
        IElement eRoot = ElementFactory.get().createElement(ELEM_CONTAINER);
        IDocument doc = ElementFactory.get().createDocument();
        doc.setRootElement(eRoot);
        if (this.permissions != null && this.permissions.size() > 0) {
            IElement ePermissions = eRoot.newElementMapped(ELEM_PERMISSIONS);
            this.getPermissions().serialize(ePermissions);
        }
        DocumentTools.save((IDocument)doc, (ILocator)this.getConfigFile());
    }

    protected void saveCRLs() throws IOException {
        for (ICRL crl : this.getCRLs()) {
            String name = crl.getName();
            name = FileTools.trimPath((String)name);
            crl.save();
        }
    }

    public void setCrls(List crls) {
        this.crls = crls;
    }

    @Override
    public void update() throws IOException {
        for (ICRL crl : this.crls) {
            crl.update();
        }
    }
}

