/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import java.util.Iterator;

public class DelegatingCertificateProvider
implements ICertificateProvider {
    protected final ICertificateProvider certificateProvider;

    public DelegatingCertificateProvider(ICertificateProvider certificateProvider) {
        this.certificateProvider = this.decorateCertificateProvider(certificateProvider);
    }

    protected boolean basicContainsCertificate(IX509Certificate certificate) {
        return this.certificateProvider.containsCertificate(certificate);
    }

    protected Iterator<IX509Certificate> basicLookupCertificates(IX509CertificateFilter filter) {
        return this.certificateProvider.lookupCertificates(filter);
    }

    @Override
    public final boolean containsCertificate(IX509Certificate certificate) {
        return this.basicContainsCertificate(certificate);
    }

    protected ICertificateProvider decorateCertificateProvider(ICertificateProvider value) {
        return value;
    }

    @Override
    public final Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        return this.basicLookupCertificates(filter);
    }
}

