/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.info;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.info.X500SimpleName;
import javax.security.auth.x500.X500Principal;

public class X500PrincipalInfo {
    private X500Principal principal;
    private X500SimpleName simpleName;

    public X500PrincipalInfo(X500Principal principal) {
        this.principal = principal;
        this.simpleName = new X500SimpleName(principal);
    }

    public String getCommonName() {
        return CertificateTools.getCommonName(this.principal);
    }

    public String getCountry() {
        String value = this.simpleName.getCountryName();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getEMail() {
        String value = this.simpleName.getEMailAddress();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getGivenName() {
        String value = this.simpleName.getByOID("2.5.4.42");
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getLocality() {
        String value = this.simpleName.getLocalityName();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getName() {
        String value = this.principal.getName("RFC1779");
        if (value == null) {
            value = this.principal.getName();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getOrganization() {
        String value = this.simpleName.getOrganizationName();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getOrganizationalUnit() {
        String value = this.simpleName.getOrganizationalUnitName();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getPseudonym() {
        String value = this.simpleName.getPseudonym();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getState() {
        String value = this.simpleName.getStateOrProvinceName();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getSurname() {
        String value = this.simpleName.getByOID("2.5.4.4");
        if (value == null) {
            value = "";
        }
        return value;
    }
}

