/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateUsageFilter;
import de.intarsys.security.certificate.filter.CommonX509CertificateFilter;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.CanonicalFromX509CertificateSelectorConverter;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.file.WildcardMatch;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;

public class X509CertificateSelector
extends CommonX509CertificateFilter
implements IElementSerializable,
IElementConfigurable,
IX509CertificateSelector,
Cloneable {
    private String alias;
    private X509CertSelector selector = new X509CertSelector();
    private boolean acceptAttributeCertificates = true;
    private CertificateUsageFilter usage;
    private Boolean hasPrivateKey;
    private IServiceTypeSelector serviceTypeSelector;
    private Boolean privateKeyAccessible;
    private String securityApplication;
    private X500Principal subject;
    private X500Principal issuer;
    private X509Name subjectName;
    private boolean subjectMatchStrict = false;
    private final WildcardMatch wildcardMatch = new WildcardMatch();

    public static X509CertificateSelector createFrom(IArgs args) throws ObjectCreationException {
        X509CertificateSelector selector = new X509CertificateSelector();
        try {
            selector.configure(ElementTools.toElement((IArgs)args));
        }
        catch (ConfigurationException e) {
            throw new ObjectCreationException((Throwable)e);
        }
        return selector;
    }

    public static X509CertificateSelector createFrom(IX509AttributeCertificate attrCert) {
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setAcceptAttributeCertificates(true);
        selector.setSerialNumber(attrCert.getSerialNumber());
        selector.setSubject(attrCert.getSubjectX500Principal());
        selector.setSubjectMatchStrict(true);
        selector.setIssuer(attrCert.getIssuerX500Principal());
        return selector;
    }

    public static X509CertificateSelector createFrom(IX509Certificate cert) {
        if (cert instanceof IX509PublicKeyCertificate) {
            return X509CertificateSelector.createFrom((IX509PublicKeyCertificate)cert);
        }
        if (cert instanceof IX509AttributeCertificate) {
            return X509CertificateSelector.createFrom((IX509AttributeCertificate)cert);
        }
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setSerialNumber(cert.getSerialNumber());
        selector.setSubject(cert.getSubjectX500Principal());
        selector.setSubjectMatchStrict(true);
        selector.setIssuer(cert.getIssuerX500Principal());
        return selector;
    }

    public static X509CertificateSelector createFrom(IX509PublicKeyCertificate certificate) {
        if (certificate == null) {
            return null;
        }
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setAcceptAttributeCertificates(false);
        selector.setCertificateUsageFilter(CertificateUsageFilter.createFromCertificateUsage(certificate.getCertificateUsage()));
        selector.setSerialNumber(certificate.getSerialNumber());
        selector.setSubject(certificate.getSubjectX500Principal());
        selector.setSubjectMatchStrict(true);
        selector.setIssuer(certificate.getIssuerX500Principal());
        return selector;
    }

    public static X509CertificateSelector createNonRepudiation() throws ObjectCreationException {
        X509CertificateSelector selector = new X509CertificateSelector();
        try {
            Args args = Args.create();
            args.put("usage", (Object)"signature_with_nonrepudiation");
            selector.configure(ElementTools.toElement((IArgs)args));
        }
        catch (ConfigurationException e) {
            throw new ObjectCreationException((Throwable)e);
        }
        return selector;
    }

    public static X509CertificateSelector createUniqueSelector(IX509PublicKeyCertificate certificate) {
        if (certificate == null) {
            return null;
        }
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setIssuer(certificate.getIssuerX500Principal());
        selector.setSerialNumber(certificate.getSerialNumber());
        return selector;
    }

    public X509CertificateSelector() {
        this((IFactory)null);
    }

    public X509CertificateSelector(IFactory factory) {
        super(factory);
    }

    protected X509CertificateSelector(X509CertSelector selector) {
        this((IFactory)null);
        this.selector = selector;
    }

    protected boolean accept(IX509AttributeCertificate certificate) {
        if (!this.isAcceptAttributeCertificates()) {
            return false;
        }
        if (this.getSerialNumber() != null && !this.getSerialNumber().equals(certificate.getSerialNumber())) {
            return false;
        }
        if (!this.matchSubject(certificate.getSubjectX500Principal())) {
            return false;
        }
        return this.matchIssuer(certificate.getIssuerX500Principal());
    }

    @Override
    public boolean accept(IX509Certificate certificate) {
        if (certificate instanceof IX509PublicKeyCertificate) {
            return this.accept((IX509PublicKeyCertificate)certificate);
        }
        if (certificate instanceof IX509AttributeCertificate) {
            return this.accept((IX509AttributeCertificate)certificate);
        }
        return false;
    }

    protected boolean accept(IX509PublicKeyCertificate certificate) {
        if (!this.matchSubject(certificate.getSubjectX500Principal())) {
            return false;
        }
        if (!this.matchIssuer(certificate.getIssuerX500Principal())) {
            return false;
        }
        try {
            if (this.match(certificate.toJavaCertificate())) {
                if (this.getCertificateUsageFilter() != null) {
                    return this.getCertificateUsageFilter().accept(certificate);
                }
                return true;
            }
            return false;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    public void addPathToName(int type, byte[] name) throws IOException {
        this.selector.addPathToName(type, name);
    }

    public void addPathToName(int type, String name) throws IOException {
        this.selector.addPathToName(type, name);
    }

    public void addSubjectAlternativeName(int type, byte[] name) throws IOException {
        this.selector.addSubjectAlternativeName(type, name);
    }

    public void addSubjectAlternativeName(int type, String name) throws IOException {
        this.selector.addSubjectAlternativeName(type, name);
    }

    public Object clone() {
        X509CertificateSelector copy = new X509CertificateSelector((X509CertSelector)this.selector.clone());
        copy.acceptAttributeCertificates = this.acceptAttributeCertificates;
        return copy;
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            String value = element.attributeValue("issuer", null);
            if (!StringTools.isEmpty((String)value)) {
                this.setIssuer(value);
            }
            if (!StringTools.isEmpty((String)(value = element.attributeValue("subject", null)))) {
                this.setSubject(value);
            }
            if (!StringTools.isEmpty((String)(value = element.attributeValue("serialnumber", null)))) {
                BigInteger serial = new BigInteger(value);
                this.setSerialNumber(serial);
            }
            if (!StringTools.isEmpty((String)(value = element.attributeValue("usage", null)))) {
                CertificateUsageFilter usageFilter = CertificateUsageFilter.createFromName(value);
                this.setCertificateUsageFilter(usageFilter);
            }
            if (!StringTools.isEmpty((String)(value = element.attributeValue("alias", null)))) {
                this.setAlias(value);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof X509CertificateSelector)) {
            return false;
        }
        X509CertificateSelector other = (X509CertificateSelector)obj;
        if (!LangTools.equals((Object)this.acceptAttributeCertificates, (Object)other.acceptAttributeCertificates)) {
            return false;
        }
        if (!LangTools.equals((Object)this.alias, (Object)other.alias)) {
            return false;
        }
        if (!LangTools.equals((Object)this.usage, (Object)other.usage)) {
            return false;
        }
        if (!LangTools.equals((Object)this.hasPrivateKey, (Object)other.hasPrivateKey)) {
            return false;
        }
        if (!LangTools.equals((Object)this.privateKeyAccessible, (Object)other.privateKeyAccessible)) {
            return false;
        }
        if (!LangTools.equals((Object)this.securityApplication, (Object)other.securityApplication)) {
            return false;
        }
        if (!LangTools.equals((Object)this.selector, (Object)other.selector)) {
            return false;
        }
        if (!LangTools.equals((Object)this.subject, (Object)other.subject)) {
            return false;
        }
        if (!LangTools.equals((Object)this.subjectMatchStrict, (Object)other.subjectMatchStrict)) {
            return false;
        }
        if (!LangTools.equals((Object)this.subjectName, (Object)other.subjectName)) {
            return false;
        }
        return LangTools.equals((Object)this.wildcardMatch, (Object)other.wildcardMatch);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.selector.getAuthorityKeyIdentifier();
    }

    public int getBasicConstraints() {
        return this.selector.getBasicConstraints();
    }

    public X509Certificate getCertificate() {
        return this.selector.getCertificate();
    }

    public CertificateUsageFilter getCertificateUsageFilter() {
        return this.usage;
    }

    public Date getCertificateValid() {
        return this.selector.getCertificateValid();
    }

    public Set<String> getExtendedKeyUsage() {
        return this.selector.getExtendedKeyUsage();
    }

    @Override
    public X500Principal getIssuer() {
        return this.issuer;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        return this.selector.getIssuerAsBytes();
    }

    public String getIssuerAsString() {
        return this.selector.getIssuerAsString();
    }

    public boolean[] getKeyUsage() {
        return this.selector.getKeyUsage();
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.usage != null) {
            sb.append(this.usage.getName());
        } else {
            sb.append("signature");
        }
        if (this.getSerialNumber() != null) {
            sb.append(" with serialnumber " + this.getSerialNumber());
        }
        if (this.getSubject() != null) {
            sb.append(" for subject " + CertificateTools.getSubjectLabel(this.getSubject()));
        }
        if (this.getIssuer() != null) {
            sb.append(" issued by " + CertificateTools.getIssuerLabel(this.getIssuer()));
        }
        return sb.toString();
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.selector.getMatchAllSubjectAltNames();
    }

    public byte[] getNameConstraints() {
        return this.selector.getNameConstraints();
    }

    public Collection<List<?>> getPathToNames() {
        return this.selector.getPathToNames();
    }

    public Set<String> getPolicy() {
        return this.selector.getPolicy();
    }

    public Date getPrivateKeyValid() {
        return this.selector.getPrivateKeyValid();
    }

    @Override
    public String getSecurityApplication() {
        return this.securityApplication;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.selector.getSerialNumber();
    }

    @Override
    public IServiceTypeSelector getServiceTypeSelector() {
        return this.serviceTypeSelector;
    }

    @Override
    public X500Principal getSubject() {
        return this.subject;
    }

    public Collection<List<?>> getSubjectAlternativeNames() {
        return this.selector.getSubjectAlternativeNames();
    }

    public byte[] getSubjectAsBytes() throws IOException {
        return this.selector.getSubjectAsBytes();
    }

    public String getSubjectAsString() {
        return this.selector.getSubjectAsString();
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        return this.selector.getSubjectKeyIdentifier();
    }

    protected X509Name getSubjectName() throws IOException {
        if (this.subjectName == null) {
            this.subjectName = X509Name.getInstance((Object)ASN1Tools.create((byte[])this.getSubject().getEncoded()));
        }
        return this.subjectName;
    }

    public PublicKey getSubjectPublicKey() {
        return this.selector.getSubjectPublicKey();
    }

    public String getSubjectPublicKeyAlgID() {
        return this.selector.getSubjectPublicKeyAlgID();
    }

    public CertificateUsageFilter getUsage() {
        return this.usage;
    }

    public int hashCode() {
        return this.selector.hashCode();
    }

    @Override
    public Boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    @Override
    public boolean isAcceptAttributeCertificates() {
        return this.acceptAttributeCertificates;
    }

    @Override
    public Boolean isPrivateKeyAccessible() {
        return this.privateKeyAccessible;
    }

    @Override
    public boolean isSubjectMatchStrict() {
        return this.subjectMatchStrict;
    }

    @Override
    public boolean isX509NonRepudiation() {
        return this.usage != null && this.usage.isX509NonRepudiation();
    }

    protected boolean match(Certificate cert) {
        return this.selector.match(cert);
    }

    protected boolean matchIssuer(X500Principal candidate) {
        if (this.getIssuer() == null) {
            return true;
        }
        if (this.getIssuer().equals(candidate)) {
            return true;
        }
        return this.getIssuer().toString().equals(candidate.toString());
    }

    protected boolean matchSubject(X500Principal candidate) {
        if (this.getSubject() == null) {
            return true;
        }
        if (this.getSubject().equals(candidate)) {
            return true;
        }
        if (this.isSubjectMatchStrict()) {
            return false;
        }
        try {
            X509Name nCandidate = X509Name.getInstance((Object)ASN1Tools.create((byte[])candidate.getEncoded()));
            for (ASN1ObjectIdentifier oid : this.getSubjectName().getOIDs()) {
                Vector candidateValues;
                Vector values = this.getSubjectName().getValues(oid);
                if (values == null || values.equals(candidateValues = nCandidate.getValues(oid))) continue;
                if (values.size() == candidateValues.size()) {
                    Iterator iValues = values.iterator();
                    Iterator iCandidateValues = candidateValues.iterator();
                    while (iValues.hasNext()) {
                        String candidateValue;
                        String value = (String)iValues.next();
                        if (this.wildcardMatch.match(value, candidateValue = (String)iCandidateValues.next())) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        CertificateUsageFilter usage;
        BigInteger serial;
        String value;
        if (this.getFactory() != null) {
            element.setAttributeValue("factory", this.getFactory().getId());
        } else {
            element.setAttributeValue("class", this.getClass().getName());
        }
        X500Principal principal = this.getSubject();
        if (principal != null) {
            value = principal.toString();
            element.setAttributeValue("subject", value);
        }
        if ((principal = this.getIssuer()) != null) {
            value = principal.toString();
            element.setAttributeValue("issuer", value);
        }
        if ((serial = this.getSerialNumber()) != null) {
            value = serial.toString();
            element.setAttributeValue("serialnumber", value);
        }
        if ((usage = this.getCertificateUsageFilter()) != null) {
            value = usage.getName();
            element.setAttributeValue("usage", value);
        }
    }

    public void setAcceptAttributeCertificates(boolean acceptAttributeCertificates) {
        this.acceptAttributeCertificates = acceptAttributeCertificates;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAuthorityKeyIdentifier(byte[] authorityKeyID) {
        this.selector.setAuthorityKeyIdentifier(authorityKeyID);
    }

    public void setBasicConstraints(int minMaxPathLen) {
        this.selector.setBasicConstraints(minMaxPathLen);
    }

    public void setCertificate(String certString) throws CertificateException {
        IX509Certificate cert = CertificateTools.createCertificate(certString);
        if (cert instanceof IX509PublicKeyCertificate) {
            this.selector.setCertificate(((IX509PublicKeyCertificate)cert).toJavaCertificate());
        }
    }

    public void setCertificate(X509Certificate cert) {
        this.selector.setCertificate(cert);
    }

    public void setCertificateUsageFilter(CertificateUsageFilter certificateUsageFilter) {
        this.usage = certificateUsageFilter;
    }

    public void setCertificateValid(Date certValid) {
        this.selector.setCertificateValid(certValid);
    }

    public void setExtendedKeyUsage(Set<String> keyPurposeSet) throws IOException {
        this.selector.setExtendedKeyUsage(keyPurposeSet);
    }

    public void setHasPrivateKey(Boolean hasPrivateKey) {
        this.hasPrivateKey = hasPrivateKey;
    }

    public void setIssuer(byte[] issuerDN) throws IOException {
        try {
            this.issuer = issuerDN == null ? null : new X500Principal(issuerDN);
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException("Invalid name").initCause(e);
        }
    }

    public void setIssuer(String issuerDN) throws IOException {
        if (issuerDN == null) {
            this.issuer = null;
        } else {
            this.setIssuer(new X500Principal(issuerDN));
        }
    }

    public void setIssuer(X500Principal issuer) {
        this.issuer = issuer;
    }

    public void setKeyUsage(boolean[] keyUsage) {
        this.selector.setKeyUsage(keyUsage);
    }

    public void setMatchAllSubjectAltNames(boolean matchAllNames) {
        this.selector.setMatchAllSubjectAltNames(matchAllNames);
    }

    public void setNameConstraints(byte[] bytes) throws IOException {
        this.selector.setNameConstraints(bytes);
    }

    public void setPathToNames(Collection names) throws IOException {
        this.selector.setPathToNames(names);
    }

    public void setPolicy(Set certPolicySet) throws IOException {
        this.selector.setPolicy(certPolicySet);
    }

    public void setPrivateKeyAccessible(Boolean privateKeyExtractable) {
        this.privateKeyAccessible = privateKeyExtractable;
    }

    public void setPrivateKeyValid(Date privateKeyValid) {
        this.selector.setPrivateKeyValid(privateKeyValid);
    }

    public void setSecurityApplication(String securityApplication) {
        this.securityApplication = securityApplication;
    }

    public void setSerialNumber(BigInteger serial) {
        this.selector.setSerialNumber(serial);
    }

    public void setServiceTypeSelector(IServiceTypeSelector serviceTypeSelector) {
        this.serviceTypeSelector = serviceTypeSelector;
    }

    public void setSubject(byte[] subjectDN) throws IOException {
        try {
            this.subject = subjectDN == null ? null : new X500Principal(subjectDN);
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException("Invalid name").initCause(e);
        }
    }

    public void setSubject(String subjectDN) throws IOException {
        if (subjectDN == null) {
            this.subject = null;
        } else {
            this.setSubject(new X500Principal(subjectDN));
        }
    }

    public void setSubject(X500Principal subject) {
        this.subject = subject;
    }

    public void setSubjectAlternativeNames(Collection names) throws IOException {
        this.selector.setSubjectAlternativeNames(names);
    }

    public void setSubjectKeyIdentifier(byte[] subjectKeyID) {
        this.selector.setSubjectKeyIdentifier(subjectKeyID);
    }

    public void setSubjectMatchStrict(boolean subjectMatchStrict) {
        this.subjectMatchStrict = subjectMatchStrict;
    }

    public void setSubjectPublicKey(byte[] key) throws IOException {
        this.selector.setSubjectPublicKey(key);
    }

    public void setSubjectPublicKey(PublicKey key) {
        this.selector.setSubjectPublicKey(key);
    }

    public void setSubjectPublicKeyAlgID(String oid) throws IOException {
        this.selector.setSubjectPublicKeyAlgID(oid);
    }

    public void setUsage(CertificateUsageFilter usage) {
        this.usage = usage;
    }

    public void setUsage(String value) throws ObjectCreationException {
        this.setUsage(CertificateUsageFilter.createFromName(value));
    }

    @Override
    public X509CertSelector toJavaSelector() {
        return this.selector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.selector.toString());
        if (this.usage != null) {
            sb.append("\nusage:");
            sb.append(this.usage.toString());
        }
        return sb.toString();
    }

    static {
        new CanonicalFromX509CertificateSelectorConverter();
    }
}

