/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import de.intarsys.security.certificate.creation.ICertificateSigner;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreator;
import de.intarsys.security.extension.common.X509ExtensionBasicConstraints;
import de.intarsys.security.extension.common.X509ExtensionExtendedKeyUsage;
import de.intarsys.security.extension.common.X509ExtensionKeyUsage;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class X509PublicKeyCertificateCreatorFactory
extends CommonInstantiatingFactory<X509PublicKeyCertificateCreator> {
    public static final String ARG_COUNTRY = "country";
    public static final String ARG_EMAIL = "email";
    public static final String ARG_KEYPAIR = "keyPair";
    public static final String ARG_LOCATION = "location";
    public static final String ARG_COMMONNAME = "commonName";
    public static final String ARG_GIVENNAME = "givenName";
    public static final String ARG_SURNAME = "surname";
    public static final String ARG_PSEUDONYM = "pseudonym";
    public static final String ARG_ORGANIZATION = "organization";
    public static final String ARG_ORGANIZATIONAL_UNIT = "organizationalUnit";
    public static final String ARG_STATE = "state";
    public static final String ARG_VALID_FROM = "validFrom";
    public static final String ARG_VALID_TO = "validTo";
    public static final String ARG_VALID_FOR = "validFor";
    public static final String ARG_DIGESTER = "digester";
    public static final String ARG_KEY_USAGE = "keyUsage";
    public static final String ARG_EXTENDED_KEY_USAGE = "extendedKeyUsage";
    public static final String ARG_EXTENDED_KEY_USAGE_CRITICAL = "extendedKeyUsageCritical";
    public static final String ARG_CA = "ca";
    public static final String ARG_CERTIFICATE_SIGNER = "certificateSigner";
    public static final String ARG_TYPE = "type";

    protected X509PublicKeyCertificateCreator basicCreateInstance(IArgs args) throws ObjectCreationException {
        X509PublicKeyCertificateCreator creator = new X509PublicKeyCertificateCreator();
        creator.setCountry(ArgTools.getString((IArgs)args, (String)ARG_COUNTRY, null));
        creator.setLocation(ArgTools.getString((IArgs)args, (String)ARG_LOCATION, null));
        creator.setName(ArgTools.getString((IArgs)args, (String)ARG_COMMONNAME, null));
        creator.setGivenName(ArgTools.getString((IArgs)args, (String)ARG_GIVENNAME, null));
        creator.setSurname(ArgTools.getString((IArgs)args, (String)ARG_SURNAME, null));
        creator.setPseudonym(ArgTools.getString((IArgs)args, (String)ARG_PSEUDONYM, null));
        creator.setOrganization(ArgTools.getString((IArgs)args, (String)ARG_ORGANIZATION, null));
        creator.setOrganizationalUnit(ArgTools.getString((IArgs)args, (String)ARG_ORGANIZATIONAL_UNIT, null));
        creator.setState(ArgTools.getString((IArgs)args, (String)ARG_STATE, null));
        creator.setEmail(ArgTools.getString((IArgs)args, (String)ARG_EMAIL, null));
        creator.setValidFrom(ArgTools.getDate((IArgs)args, (String)ARG_VALID_FROM, null));
        if (args.isDefined(ARG_VALID_TO)) {
            creator.setValidTo(ArgTools.getDate((IArgs)args, (String)ARG_VALID_TO, null));
        } else if (args.isDefined(ARG_VALID_FOR)) {
            GregorianCalendar calValidTo = new GregorianCalendar();
            ((Calendar)calValidTo).add(5, ArgTools.getInt((IArgs)args, (String)ARG_VALID_FOR, (int)1));
            creator.setValidTo(ArgTools.getDate((IArgs)args, (String)ARG_VALID_TO, (Date)calValidTo.getTime()));
        }
        creator.setDigestAlgorithmName(ArgTools.getString((IArgs)args, (String)ARG_DIGESTER, (String)"SHA-256"));
        int keyUsage = 0;
        boolean ca = false;
        List<String> extKeyUsage = new ArrayList();
        boolean extKeyUsageCritical = false;
        List types = ArgTools.getList((IArgs)args, (String)ARG_TYPE, null);
        if (types != null && !types.isEmpty()) {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                String type;
                switch (type = (String)iterator.next()) {
                    case "digitalSignature": {
                        keyUsage |= 0x80;
                        extKeyUsage.add(KeyPurposeId.id_kp_clientAuth.getId());
                        extKeyUsage.add(KeyPurposeId.id_kp_emailProtection.getId());
                        break;
                    }
                    case "crypt": {
                        keyUsage |= 0x30;
                        break;
                    }
                    case "ca": {
                        keyUsage |= 6;
                        ca = true;
                        break;
                    }
                    case "tsa": {
                        keyUsage |= 0x80;
                        extKeyUsage.add(KeyPurposeId.id_kp_timeStamping.getId());
                        extKeyUsageCritical = true;
                        break;
                    }
                    case "sslServer": {
                        keyUsage |= 0x28;
                        extKeyUsage.add(KeyPurposeId.id_kp_serverAuth.getId());
                        break;
                    }
                }
            }
        } else {
            keyUsage = ArgTools.getInt((IArgs)args, (String)ARG_KEY_USAGE, (int)144);
            extKeyUsage = (List)args.get(ARG_EXTENDED_KEY_USAGE);
            ca = ArgTools.getBoolStrict((IArgs)args, (String)ARG_CA, (boolean)false);
            extKeyUsageCritical = ArgTools.getBoolStrict((IArgs)args, (String)ARG_EXTENDED_KEY_USAGE_CRITICAL, (boolean)false);
        }
        if (keyUsage != 0) {
            creator.addExtension(new X509ExtensionKeyUsage(keyUsage));
        }
        if (extKeyUsage != null && !extKeyUsage.isEmpty()) {
            X509ExtensionExtendedKeyUsage eku = new X509ExtensionExtendedKeyUsage(extKeyUsage);
            eku.setCritical(extKeyUsageCritical);
            creator.addExtension(eku);
        }
        if (ca) {
            creator.addExtension(new X509ExtensionBasicConstraints(true));
        }
        creator.setSigner((ICertificateSigner)args.get(ARG_CERTIFICATE_SIGNER));
        return creator;
    }

    public Class<X509PublicKeyCertificateCreator> getResultType() {
        return X509PublicKeyCertificateCreator.class;
    }
}

