/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.CertificateCreationTools;
import de.intarsys.security.certificate.creation.DefaultCertificateSigner;
import de.intarsys.security.certificate.creation.ICertificateSigner;
import de.intarsys.security.certificate.creation.RSAKeyPairFactory;
import de.intarsys.security.certificate.creation.X509PublicKeyCertifier;
import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class X509PublicKeyCertificateCreator {
    private String name;
    private String givenName;
    private String surname;
    private String pseudonym;
    private String title;
    private String location;
    private String state;
    private String organization;
    private String organizationalUnit;
    private String country;
    private String email;
    private Date validFrom;
    private Date validTo;
    private BigInteger serialNumber;
    private final List<IX509Extension> extensions = new ArrayList<IX509Extension>();
    private KeyPair keyPair;
    private String digestAlgorithmName = "SHA-256";
    private ICertificateSigner signer;

    public void addExtension(IX509Extension extension) {
        this.extensions.add(extension);
    }

    public KeyCertificatePair createEntity() throws Exception {
        KeyPair keyPair = this.getKeyPair();
        if (keyPair == null) {
            keyPair = (KeyPair)FactoryTools.createInstance((Object)RSAKeyPairFactory.ID, (IArgs)Args.create());
        }
        X509PublicKeyCertifier certifier = new X509PublicKeyCertifier();
        ICertificateSigner signer = this.getSigner();
        if (signer == null) {
            signer = new DefaultCertificateSigner(null, keyPair.getPrivate());
        }
        certifier.setSigner(signer);
        certifier.setPublicKey(keyPair.getPublic());
        certifier.setDigestAlgorithmName(this.getDigestAlgorithmName());
        certifier.setSerialNumber(this.getSerialNumber());
        certifier.setValidFrom(this.getValidFrom());
        certifier.setValidTo(this.getValidTo());
        certifier.setSubject(this.createSubjectPrincipal());
        for (IX509Extension extension : this.getExtensions()) {
            certifier.addExtension(extension);
        }
        IX509PublicKeyCertificate newCert = certifier.createCertificate();
        return new KeyCertificatePair(keyPair.getPrivate(), newCert);
    }

    private X500Principal createSubjectPrincipal() throws IOException {
        HashMap<String, String> nameAttributes = new HashMap<String, String>();
        this.putIfNotEmpty(nameAttributes, "1.2.840.113549.1.9.1", this.getEmail());
        this.putIfNotEmpty(nameAttributes, "2.5.4.3", this.getName());
        this.putIfNotEmpty(nameAttributes, "2.5.4.42", this.getGivenName());
        this.putIfNotEmpty(nameAttributes, "2.5.4.4", this.getSurname());
        this.putIfNotEmpty(nameAttributes, "2.5.4.65", this.getPseudonym());
        this.putIfNotEmpty(nameAttributes, "2.5.4.7", this.getLocation());
        this.putIfNotEmpty(nameAttributes, "2.5.4.8", this.getState());
        this.putIfNotEmpty(nameAttributes, "2.5.4.10", this.getOrganization());
        this.putIfNotEmpty(nameAttributes, "2.5.4.11", this.getOrganizationalUnit());
        this.putIfNotEmpty(nameAttributes, "2.5.4.6", this.getCountry());
        return CertificateCreationTools.createX500Principal(nameAttributes);
    }

    public String getCountry() {
        return this.country;
    }

    public String getDigestAlgorithmName() {
        return this.digestAlgorithmName;
    }

    public String getEmail() {
        return this.email;
    }

    public List<IX509Extension> getExtensions() {
        return new ArrayList<IX509Extension>(this.extensions);
    }

    public String getGivenName() {
        return this.givenName;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public String getPseudonym() {
        return this.pseudonym;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public ICertificateSigner getSigner() {
        return this.signer;
    }

    public String getState() {
        return this.state;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    private void putIfNotEmpty(Map<String, String> attributes, String oid, String value) {
        if (!StringTools.isEmpty((String)value)) {
            String evaluatedValue = TemplateEvaluator.evaluateString((Mode)Mode.UNTRUSTED, (String)value);
            attributes.put(oid, evaluatedValue);
        }
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setDigestAlgorithmName(String digestAlgorithmName) {
        this.digestAlgorithmName = digestAlgorithmName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void setPseudonym(String pseudonym) {
        this.pseudonym = pseudonym;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSigner(ICertificateSigner signer) {
        this.signer = signer;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }
}

