/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.algorithm.rsa.RsaTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.CertificateSignerException;
import de.intarsys.security.certificate.creation.ICertificateSigner;
import de.intarsys.tools.digest.DigestTools;
import java.security.PrivateKey;
import java.security.Signature;
import javax.crypto.Cipher;

public class DefaultCertificateSigner
implements ICertificateSigner {
    private final PrivateKey privateKey;
    private final IX509PublicKeyCertificate certificate;

    public DefaultCertificateSigner(IX509PublicKeyCertificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public IX509PublicKeyCertificate[] getCertificatePath() {
        if (this.certificate == null) {
            return new IX509PublicKeyCertificate[0];
        }
        return new IX509PublicKeyCertificate[]{this.certificate};
    }

    @Override
    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public byte[] sign(byte[] data) throws CertificateSignerException {
        if (PpkTools.isSignatureAlgorithmECDSA(this.getPrivateKey().getAlgorithm())) {
            return this.signECDSA(data);
        }
        return this.signRSA(data);
    }

    protected byte[] signECDSA(byte[] data) throws CertificateSignerException {
        try {
            Signature sig = Signature.getInstance("NONEwithECDSA", "BC");
            sig.initSign(this.getPrivateKey());
            byte[] decodedDigest = DigestTools.decode((byte[])data).getBytes();
            sig.update(decodedDigest);
            return sig.sign();
        }
        catch (Exception e) {
            throw new CertificateSignerException(e);
        }
    }

    protected byte[] signRSA(byte[] data) throws CertificateSignerException {
        try {
            Cipher cipher = RsaTools.lookupRSACipher();
            cipher.init(1, this.getPrivateKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CertificateSignerException(e);
        }
    }
}

