/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.certificate.common.CommonX509PublicKeyCertificate;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509V3PublicKeyCertificate
extends CommonX509PublicKeyCertificate {
    private X509Certificate cert;
    private SoftReference<X500Principal> subjectX500Principal;
    private SoftReference<X500Principal> issuerX500Principal;
    private SoftReference<BigInteger> serialNumber;

    public X509V3PublicKeyCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    @Override
    public int getBasicConstraints() {
        return this.cert.getBasicConstraints();
    }

    @Override
    public byte[] getCertificateInfo() throws CertificateEncodingException {
        return this.cert.getTBSCertificate();
    }

    public Set getCriticalExtensionOIDs() {
        return this.cert.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    @Override
    public List getExtendedKeyUsage() throws CertificateParsingException {
        return this.cert.getExtendedKeyUsage();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.cert.getExtensionValue(oid);
    }

    @Override
    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return this.cert.getIssuerAlternativeNames();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.cert.getIssuerUniqueID();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        X500Principal value = null;
        if (this.issuerX500Principal != null) {
            value = this.issuerX500Principal.get();
        }
        if (value == null) {
            value = this.cert.getIssuerX500Principal();
            this.issuerX500Principal = new SoftReference<X500Principal>(value);
        }
        return value;
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.cert.getKeyUsage();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.cert.getNonCriticalExtensionOIDs();
    }

    @Override
    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    @Override
    public BigInteger getSerialNumber() {
        BigInteger value = null;
        if (this.serialNumber != null) {
            value = this.serialNumber.get();
        }
        if (value == null) {
            value = this.cert.getSerialNumber();
            this.serialNumber = new SoftReference<BigInteger>(value);
        }
        return value;
    }

    @Override
    public String getSigAlgOID() {
        return this.cert.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.cert.getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignature();
    }

    @Override
    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return this.cert.getSubjectAlternativeNames();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.cert.getSubjectUniqueID();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        X500Principal value = null;
        if (this.subjectX500Principal != null) {
            value = this.subjectX500Principal.get();
        }
        if (value == null) {
            value = this.cert.getSubjectX500Principal();
            this.subjectX500Principal = new SoftReference<X500Principal>(value);
        }
        return value;
    }

    @Override
    public int getVersion() {
        return this.cert.getVersion();
    }

    @Override
    public int hashCode() {
        return this.cert.hashCode();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.cert.hasUnsupportedCriticalExtension();
    }

    @Override
    public X509Certificate toJavaCertificate() throws CertificateException {
        return this.cert;
    }
}

