/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

public class X509CertificatePath
implements IX509CertificatePath {
    private final List path;

    public X509CertificatePath(List path) {
        if (path == null) {
            path = new ArrayList();
        }
        this.path = path;
    }

    @Override
    public IX509Certificate getCertificate(int index) {
        return (IX509Certificate)this.path.get(index - 1);
    }

    @Override
    public IX509PublicKeyCertificate getIssuerCertificate(IX509Certificate issuedCertificate) {
        if (issuedCertificate == null) {
            return null;
        }
        IX509PublicKeyCertificate lastCertificate = null;
        for (IX509Certificate certificate : this.path) {
            if (issuedCertificate.equals(certificate)) {
                return lastCertificate;
            }
            if (!(certificate instanceof IX509PublicKeyCertificate)) continue;
            lastCertificate = (IX509PublicKeyCertificate)certificate;
        }
        return null;
    }

    @Override
    public IX509Certificate getLeafCertificate() {
        if (this.size() == 0) {
            return null;
        }
        return this.getCertificate(this.size());
    }

    public List getPath() {
        return new ArrayList(this.path);
    }

    @Override
    public IX509Certificate getRootCertificate() {
        if (this.size() == 0) {
            return null;
        }
        return this.getCertificate(1);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public int size() {
        return this.path.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(StringTools.LS);
        for (IX509Certificate cert : this.path) {
            String subject = cert.getSubjectX500Principal().getName("RFC1779");
            String serial = cert.getSerialNumber().toString();
            builder.append(subject);
            builder.append(" / ");
            builder.append(serial);
            builder.append(StringTools.LS);
        }
        builder.append("]").append(StringTools.LS);
        return builder.toString();
    }
}

