/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.List;

public class TrustBase
implements ITrustBase,
IPrettyPrintable {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final String type;
    private List<String> trustedApplications = new ArrayList<String>();

    public TrustBase(String type) {
        this.type = type;
    }

    public void addTrustedApplication(String id) {
        this.trustedApplications.add(id);
    }

    @Override
    public String getLabel() {
        return Msg.getString("TrustBase.Type_" + this.type, new Object[0]);
    }

    @Override
    public String[] getTrustedApplications() {
        return this.trustedApplications.toArray(new String[this.trustedApplications.size()]);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("type", (Object)this.getType(), null);
    }
}

