/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate;

import de.intarsys.asn1.common.EDIPartyName;
import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.common.OtherName;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.RDNSequence;
import de.intarsys.security.certificate.CertificateEncodingIdentityFilterIterator;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificateReference;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificateOwner;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.CertificateFilterIterator;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.ReferencedAttributeCertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorSerializer;
import de.intarsys.security.certificate.info.X500PrincipalInfo;
import de.intarsys.security.certificate.info.X500SimpleName;
import de.intarsys.security.certificate.provider.standard.AttributeCertificateProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.extension.IQCStatementsHandler;
import de.intarsys.security.extension.IX509ExtensionHandler;
import de.intarsys.security.extension.X509ExtensionRegistry;
import de.intarsys.security.extension.common.ValidityModel;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.RequestFile;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.streaming.StreamingTools;
import de.intarsys.tools.string.StringTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.UserNotice;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateTools {
    private static final String AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    private static final String BASIC_CONSTRAINTS = "2.5.29.19";
    private static final Logger Log = LoggerFactory.getLogger(CertificateTools.class);
    private static final String QC_STATEMENTS = "1.3.6.1.5.5.7.1.3";
    public static final String ARG_ATTRIBUTECERTIFICATES = "attributeCertificates";
    public static final String LOCATOR_RECENTCONTEXT = "de.intarsys.security.certificate";
    private static final String CERTIFICATE_POLICIES = "2.5.29.32";
    private static final String id_qt_unotice = "1.3.6.1.5.5.7.2.2";

    public static boolean containsCertificate(IX509Certificate certificate, Collection<IX509Certificate> collection) {
        if (collection == null) {
            return false;
        }
        return collection.contains(certificate);
    }

    public static IX509CertificateFilter createAuthorityKeySelector(X509Extension x509Element) throws IOException {
        org.bouncycastle.asn1.x509.GeneralNames issuerName;
        AuthorityKeyIdentifier authKeyId = CertificateTools.getAuthorityKeyIdentifier(x509Element);
        if (authKeyId == null) {
            return null;
        }
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setAcceptAttributeCertificates(false);
        byte[] keyIdentifier = authKeyId.getKeyIdentifier();
        if (keyIdentifier != null) {
            try {
                keyIdentifier = ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{new DEROctetString(keyIdentifier)});
                selector.setSubjectKeyIdentifier(keyIdentifier);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((issuerName = authKeyId.getAuthorityCertIssuer()) != null) {
            GeneralNames generalNames = (GeneralNames)GeneralNames.FACTORY.create((ASN1Encodable)issuerName);
            X500Principal issuer = CertificateTools.parsePrincipal(generalNames);
            selector.setIssuer(issuer);
        }
        selector.setSerialNumber(authKeyId.getAuthorityCertSerialNumber());
        return selector;
    }

    protected static IX509Certificate createCertificate(byte[] bytes) throws CertificateException {
        return X509CertificateFactory.get().createCertificate(bytes);
    }

    public static IX509Certificate createCertificate(Object object) throws CertificateException {
        if (object == null) {
            return null;
        }
        if (object instanceof IX509Certificate) {
            return (IX509Certificate)object;
        }
        if (object instanceof IX509PublicKeyCertificateOwner) {
            return ((IX509PublicKeyCertificateOwner)object).getX509PublicKeyCertificate();
        }
        if (object instanceof X509Certificate) {
            return CertificateTools.wrapJavaCert((X509Certificate)object);
        }
        if (object instanceof ILocator) {
            try {
                return CertificateTools.createCertificate(LocatorTools.getBytes((ILocator)((ILocator)object)));
            }
            catch (IOException e) {
                throw new CertificateException(e.getLocalizedMessage(), e);
            }
        }
        if (object instanceof byte[]) {
            return CertificateTools.createCertificate((byte[])object);
        }
        if (object instanceof String) {
            try {
                return CertificateTools.createCertificate(Base64.decode((String)((String)object)));
            }
            catch (IOException e) {
                throw new CertificateException("can decode certificate");
            }
        }
        throw new IllegalArgumentException("invalid data type");
    }

    public static IX509CertificateFilter createIssuerSelector(IX509Certificate certificate) {
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setAcceptAttributeCertificates(false);
        selector.setSubject(certificate.getIssuerX500Principal());
        selector.setSubjectMatchStrict(true);
        boolean[] keyUsage = new boolean[9];
        keyUsage[5] = true;
        selector.setKeyUsage(keyUsage);
        return selector;
    }

    public static IX509CertificateFilter[] createIssuerSelectors(IX509Certificate certificate) {
        IX509CertificateFilter[] selectors = new IX509CertificateFilter[2];
        try {
            selectors[0] = CertificateTools.createAuthorityKeySelector(certificate);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        selectors[1] = CertificateTools.createIssuerSelector(certificate);
        return selectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate createJavaCertificate(ILocator locator, int id) throws IOException, CertificateException {
        X509Certificate certificate = null;
        InputStream input = null;
        try {
            input = locator.getInputStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(input);
            Object[] cArr = c.toArray();
            for (int i = 0; i < cArr.length; ++i) {
                if (i != id) continue;
                certificate = (X509Certificate)cArr[i];
                break;
            }
        }
        finally {
            StreamTools.close((Closeable)input);
        }
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List createJavaCertificates(ILocator locator) throws IOException, CertificateException {
        InputStream input = null;
        try {
            input = locator.getInputStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>(cf.generateCertificates(input));
            return arrayList;
        }
        finally {
            StreamTools.close((Closeable)input);
        }
    }

    public static List<X509Certificate> createJavaCertificates(KeyStore keystore) throws KeyStoreException {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        Enumeration<String> e = keystore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement().toString();
            X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
            certificateList.add(cert);
        }
        return certificateList;
    }

    public static CertStore createJavaCertStore(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        try {
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(collection));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Register BouncyCastle Provider before use", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Register BouncyCastle Provider before use", e);
        }
    }

    public static boolean equals(IX509Certificate certificate1, Object obj) {
        if (obj == certificate1) {
            return true;
        }
        if (!(obj instanceof IX509Certificate)) {
            return false;
        }
        IX509Certificate certificate2 = (IX509Certificate)obj;
        if (!certificate1.getSerialNumber().equals(certificate2.getSerialNumber())) {
            return false;
        }
        try {
            byte[] b1 = certificate1.getEncoded();
            byte[] b2 = certificate2.getEncoded();
            return Arrays.areEqual((byte[])b1, (byte[])b2);
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }

    protected static String expand(String template, X500Principal x500Principal) {
        String result;
        if (x500Principal == null) {
            return "";
        }
        X500SimpleName name = new X500SimpleName(x500Principal);
        TaggedStringEvaluator stringEvaluator = new TaggedStringEvaluator((IStringEvaluator)name, false);
        try {
            result = (String)stringEvaluator.evaluate(template, (IArgs)Args.create());
        }
        catch (EvaluationException e) {
            return x500Principal.toString();
        }
        result = result.trim();
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static <C extends IX509Certificate> List<C> filterCertificates(Collection<C> certificates, IX509CertificateFilter filter) {
        Iterator<C> filteredCertificates = CertificateTools.filterCertificates(certificates.iterator(), filter);
        return ListTools.toList(filteredCertificates);
    }

    public static <C extends IX509Certificate> Iterator<C> filterCertificates(Iterator<C> certificates, IX509CertificateFilter filter) {
        if (filter == null) {
            filter = AllCertificateFilter.UNIQUE;
        }
        return new CertificateFilterIterator<C>(certificates, filter);
    }

    protected static Iterator<IX509AttributeCertificate> getAllAttributeCertificatesForSigner(IX509PublicKeyCertificate cert) {
        ReferencedAttributeCertificateSelector filter = ReferencedAttributeCertificateSelector.createFrom(cert);
        Object environmentCerts = AttributeCertificateProvider.get().lookupCertificates(filter);
        environmentCerts = new CertificateEncodingIdentityFilterIterator<IX509Certificate>((Iterator<IX509Certificate>)environmentCerts);
        return environmentCerts;
    }

    public static Set<IX509AttributeCertificate> getAttributeCertificates(IX509PublicKeyCertificate cert, IArgs args) throws IOException {
        final List<IX509CertificateFilter> selectorList = CertificateTools.getAttributeCertificateSelectors(args);
        if (selectorList.isEmpty()) {
            return Collections.emptySet();
        }
        Iterator<IX509AttributeCertificate> iAttributeCertificates = CertificateTools.getAllAttributeCertificatesForSigner(cert);
        iAttributeCertificates = new FilterIterator<IX509AttributeCertificate>(iAttributeCertificates){

            protected boolean accept(IX509AttributeCertificate attrCert) {
                for (IX509CertificateFilter filter : selectorList) {
                    if (!filter.accept(attrCert)) continue;
                    return true;
                }
                return false;
            }
        };
        List attributeCertificates = ListTools.toList(iAttributeCertificates);
        if (selectorList.size() != attributeCertificates.size()) {
            String msg = "No or not all attribute certificates found matching the specified selectors: Please check your ARG 'attributeCertificates'.";
            Log.warn(msg);
        }
        return new HashSet<IX509AttributeCertificate>(attributeCertificates);
    }

    public static List<IX509CertificateFilter> getAttributeCertificateSelectors(IArgs args) throws IOException {
        Object value = ArgTools.getObject((IArgs)args, (String)ARG_ATTRIBUTECERTIFICATES, null);
        if (value == null) {
            value = ArgTools.getObject((IArgs)args, (String)"digestSigner.args.attributeCertificates", null);
        }
        return CertificateTools.toAttributeCertificateSelectors(value);
    }

    public static AuthorityKeyIdentifier getAuthorityKeyIdentifier(X509Extension x509Element) throws IOException {
        ASN1Primitive derAuthorityKeyIdentifier = CertificateTools.getExtensionValue(x509Element, "2.5.29.35");
        if (derAuthorityKeyIdentifier == null) {
            return null;
        }
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)derAuthorityKeyIdentifier);
        return authorityKeyIdentifier;
    }

    protected static BasicConstraints getBasicConstraints(IX509Certificate certificate) throws IOException {
        ASN1Primitive derBasicConstraints = CertificateTools.getExtensionValue(certificate, BASIC_CONSTRAINTS);
        if (derBasicConstraints == null) {
            return null;
        }
        BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)derBasicConstraints);
        return basicConstraints;
    }

    public static String getCommonName(X500Principal x500Principal) {
        StringBuilder builder = new StringBuilder();
        String name = CertificateTools.expand("${PSEUDONYM}", x500Principal);
        if (!StringTools.isEmpty((String)name)) {
            builder.append(name).append(" (Pseudonym)");
        } else {
            name = CertificateTools.expand("${GIVENNAME} ${SURNAME}", x500Principal);
            if (StringTools.isEmpty((String)name) && StringTools.isEmpty((String)(name = CertificateTools.expand("${CN}", x500Principal)))) {
                name = "";
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public static String getCommonNameAndOrganization(X500Principal x500Principal) {
        StringBuilder builder = new StringBuilder();
        builder.append(CertificateTools.getCommonName(x500Principal));
        String organization = CertificateTools.expand("${O}", x500Principal);
        if (!StringTools.isEmpty((String)organization)) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(organization);
        }
        return builder.toString();
    }

    public static Collection<IX509AttributeCertificate> getDistinctAttributeCertificates(Iterator<IX509Certificate> certificates) {
        return StreamingTools.asStream(certificates).filter(o -> o instanceof IX509AttributeCertificate).map(o -> new ComparableCertificate((IX509Certificate)o)).distinct().map(o -> (IX509AttributeCertificate)o.getCertificate()).collect(Collectors.toList());
    }

    public static Collection<IX509AttributeCertificate> getDistinctAttributeCertificates(IX509CertificateFilter filter) {
        Iterator<IX509Certificate> certs = AttributeCertificateProvider.get().lookupCertificates(filter);
        return CertificateTools.getDistinctAttributeCertificates(certs);
    }

    public static String getEMail(IX509Certificate certificate) {
        String email;
        X500PrincipalInfo subjectPrincipal;
        X500Principal subject = certificate.getSubjectX500Principal();
        if (subject != null && (subjectPrincipal = new X500PrincipalInfo(certificate.getSubjectX500Principal())) != null && !StringTools.isEmpty((String)(email = subjectPrincipal.getEMail()))) {
            return email;
        }
        try {
            GeneralName[] aSubjectAltNames;
            ASN1Primitive obj = CertificateTools.getExtensionValue(certificate, "2.5.29.17");
            org.bouncycastle.asn1.x509.GeneralNames subjectAltNames = org.bouncycastle.asn1.x509.GeneralNames.getInstance((Object)obj);
            if (subjectAltNames != null && (aSubjectAltNames = subjectAltNames.getNames()) != null) {
                for (GeneralName subjectAltName : aSubjectAltNames) {
                    ASN1Encodable derSubjectAltName;
                    String email2;
                    if (subjectAltName.getTagNo() != 1 || StringTools.isEmpty((String)(email2 = ((DERIA5String)(derSubjectAltName = subjectAltName.getName())).getString()))) continue;
                    return email2;
                }
            }
        }
        catch (IOException e) {
            Log.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return "";
    }

    public static ExtendedKeyUsage getExtendedKeyUsage(IX509PublicKeyCertificate certificate) throws IOException {
        ASN1Primitive derKeyUsage = CertificateTools.getExtensionValue(certificate, "2.5.29.37");
        if (derKeyUsage == null) {
            return null;
        }
        return ExtendedKeyUsage.getInstance((Object)derKeyUsage);
    }

    public static ASN1Primitive getExtensionValue(X509Extension x509Element, String oid) throws IOException {
        byte[] bytes = x509Element.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return CertificateTools.unwrapExtensionValue(bytes);
    }

    public static String getExtensionValueAsString(X509Extension x509Element, String oid) throws IOException {
        byte[] bytes = x509Element.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return CertificateTools.unwrapExtensionValue(bytes).toString();
    }

    public static byte[] getFingerPrint(IX509Certificate certificate, String algorithm) throws NoSuchAlgorithmException, CertificateEncodingException {
        IDigester digester = DigestTools.createDigester((String)algorithm);
        IDigest digest = digester.digest(certificate.getEncoded());
        return digest.getBytes();
    }

    public static byte[] getFingerPrintSHA1(IX509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        return CertificateTools.getFingerPrint(certificate, "SHA1");
    }

    public static String getIssuerLabel(IX509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        return CertificateTools.getIssuerLabel(certificate.getIssuerX500Principal());
    }

    public static String getIssuerLabel(X500Principal x500Principal) {
        return CertificateTools.getCommonNameAndOrganization(x500Principal);
    }

    public static KeyUsage getKeyUsage(IX509Certificate certificate) throws IOException {
        ASN1Primitive derKeyUsage = CertificateTools.getExtensionValue(certificate, "2.5.29.15");
        if (derKeyUsage == null) {
            return null;
        }
        return KeyUsage.getInstance((Object)derKeyUsage);
    }

    public static String getMonetaryLimit(IX509Certificate certificate) {
        IX509ExtensionHandler handler = X509ExtensionRegistry.get().lookupExtensionHandler(QC_STATEMENTS);
        if (handler instanceof IQCStatementsHandler) {
            try {
                return ((IQCStatementsHandler)handler).getMonetaryLimit(certificate);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getNotAfterLabel(IX509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        Date date = certificate.getNotAfter();
        if (date == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(date);
    }

    public static String getNotBeforeLabel(IX509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        Date date = certificate.getNotBefore();
        if (date == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(date);
    }

    protected static List<String> getNoticeTexts(PolicyInformation policyInformation) {
        if (policyInformation == null) {
            return Collections.emptyList();
        }
        ASN1Sequence derPolicyQualifiers = policyInformation.getPolicyQualifiers();
        if (derPolicyQualifiers == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Enumeration en = derPolicyQualifiers.getObjects();
        while (en.hasMoreElements()) {
            UserNotice notice;
            ASN1Encodable derPolicyQualifier = (ASN1Encodable)en.nextElement();
            PolicyQualifierInfo policyQualifierInfo = PolicyQualifierInfo.getInstance((Object)derPolicyQualifier);
            String id = policyQualifierInfo.getPolicyQualifierId().getId();
            if (!id_qt_unotice.equals(id) || (notice = UserNotice.getInstance((Object)policyQualifierInfo.getQualifier())).getExplicitText() == null) continue;
            String text = notice.getExplicitText().getString();
            result.add(text);
        }
        return result;
    }

    protected static List<String> getOcspURLs(AuthorityInformationAccess authInfoAccess) {
        ArrayList<String> urls = new ArrayList<String>();
        AccessDescription[] ads = authInfoAccess.getAccessDescriptions();
        for (int i = 0; i < ads.length; ++i) {
            GeneralName location;
            if (!ads[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp) || (location = ads[i].getAccessLocation()).getTagNo() != 6) continue;
            String url = ((DERIA5String)location.getName()).getString();
            urls.add(url);
        }
        return urls;
    }

    public static List<String> getOcspURLs(IX509Certificate certificate) throws IOException {
        ASN1Primitive derAuthInfoAccess = CertificateTools.getExtensionValue(certificate, AUTHORITY_INFO_ACCESS);
        if (derAuthInfoAccess == null) {
            return null;
        }
        return CertificateTools.getOcspURLs(AuthorityInformationAccess.getInstance((Object)derAuthInfoAccess));
    }

    public static String getOrganization(X500Principal x500Principal) {
        String organization = CertificateTools.expand("${O}", x500Principal);
        return organization == null ? "" : organization;
    }

    public static List<PolicyInformation> getPolicies(IX509Certificate certificate) throws IOException {
        ArrayList<PolicyInformation> result = new ArrayList<PolicyInformation>();
        ASN1Sequence derExplicitPolicies = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, CERTIFICATE_POLICIES);
        if (derExplicitPolicies != null) {
            Enumeration e = derExplicitPolicies.getObjects();
            while (e.hasMoreElements()) {
                ASN1Encodable derPolicyInformation = (ASN1Encodable)e.nextElement();
                PolicyInformation policyInformation = PolicyInformation.getInstance((Object)derPolicyInformation);
                result.add(policyInformation);
            }
        }
        return result;
    }

    public static PolicyInformation getPolicy(IX509Certificate certificate, ASN1ObjectIdentifier oid) throws IOException {
        ASN1Sequence derExplicitPolicies = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, CERTIFICATE_POLICIES);
        if (derExplicitPolicies == null) {
            return null;
        }
        Enumeration e = derExplicitPolicies.getObjects();
        while (e.hasMoreElements()) {
            ASN1Encodable derPolicyInformation = (ASN1Encodable)e.nextElement();
            PolicyInformation policyInformation = PolicyInformation.getInstance((Object)derPolicyInformation);
            ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
            if (!policyIdentifier.equals((ASN1Primitive)oid)) continue;
            return policyInformation;
        }
        return null;
    }

    public static List<String> getPolicyNoticeTexts(IX509Certificate certificate) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        List<PolicyInformation> policies = CertificateTools.getPolicies(certificate);
        for (PolicyInformation policyInformation : policies) {
            result.addAll(CertificateTools.getNoticeTexts(policyInformation));
        }
        return result;
    }

    public static ASN1Sequence getQCStatements(IX509Certificate certificate) throws IOException {
        ASN1Sequence derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, QC_STATEMENTS);
        return derQCStatements;
    }

    public static String getRecentLoadLocation() {
        return CertificateTools.getRecentLocation("load");
    }

    public static String getRecentLocation(String action) {
        String location = LocatorUsage.get().getLastLocator(action, LOCATOR_RECENTCONTEXT);
        if (location == null) {
            location = FileEnvironment.get().getBaseDir().getAbsolutePath();
        }
        return location;
    }

    public static String getRecentSaveLocation() {
        return CertificateTools.getRecentLocation("save");
    }

    public static String getRestrictionLabel(IX509PublicKeyCertificate certificate) {
        IX509Attribute[] attributes;
        if (certificate == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (IX509Attribute attribute : attributes = certificate.getX509Attributes()) {
            sb.append(attribute.getLabel());
            sb.append(": ");
            sb.append(attribute.getStringValue());
            sb.append(StringTools.LS);
        }
        String value = CertificateTools.getMonetaryLimit(certificate);
        if (!StringTools.isEmpty((String)value)) {
            sb.append(value);
            sb.append(StringTools.LS);
        }
        return sb.toString();
    }

    public static String getSerialNumber(IX509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        if (certificate.getSerialNumber() == null) {
            return "";
        }
        return certificate.getSerialNumber().toString();
    }

    public static org.bouncycastle.asn1.x509.GeneralNames getSubjectAltNames(IX509Certificate certificate) throws IOException {
        ASN1Primitive obj = CertificateTools.getExtensionValue(certificate, "2.5.29.17");
        if (obj == null) {
            return null;
        }
        return org.bouncycastle.asn1.x509.GeneralNames.getInstance((Object)obj);
    }

    public static byte[] getSubjectKeyIdentifier(X509Extension x509Element) throws IOException {
        ASN1Primitive derSubjectKeyIdentifier = CertificateTools.getExtensionValue(x509Element, "2.5.29.14");
        if (derSubjectKeyIdentifier == null) {
            return null;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance((Object)derSubjectKeyIdentifier);
        byte[] keyIdentifier = subjectKeyIdentifier.getKeyIdentifier();
        return keyIdentifier;
    }

    public static String getSubjectLabel(IX509Certificate certificate) {
        if (certificate instanceof IX509PublicKeyCertificate) {
            return CertificateTools.getSubjectLabel(certificate.getSubjectX500Principal());
        }
        if (certificate instanceof IX509AttributeCertificate) {
            IX509CertificateReference ref = ((IX509AttributeCertificate)certificate).getSubject();
            if (ref != null) {
                X500Principal subject = ref.getSubjectX500Principal();
                if (subject != null) {
                    return CertificateTools.getSubjectLabel(subject);
                }
                X500Principal issuer = ref.getIssuerX500Principal();
                if (issuer != null) {
                    String name = CertificateTools.getCommonNameAndOrganization(issuer);
                    return ref.getSerialNumber() + " / " + name;
                }
            }
            return "unknown";
        }
        return "";
    }

    public static String getSubjectLabel(X500Principal x500Principal) {
        return CertificateTools.getCommonNameAndOrganization(x500Principal);
    }

    public static String getUniqueIdentifier(IX509PublicKeyCertificate certificate) {
        if (certificate == null) {
            return null;
        }
        try {
            X509CertificateSelector selector = new X509CertificateSelector();
            selector.setIssuer(certificate.getIssuerX500Principal());
            selector.setSerialNumber(certificate.getSerialNumber());
            X509CertificateSelectorSerializer serializer = new X509CertificateSelectorSerializer();
            return serializer.serialize(selector);
        }
        catch (IOException e) {
            return "<failed>";
        }
    }

    public static String getUsageLabel(IX509PublicKeyCertificate certificate) {
        if (certificate == null) {
            return "";
        }
        return certificate.getCertificateUsage().getLabel();
    }

    public static ValidityModel getValidityModel(X509Extension x509Element) throws IOException {
        ASN1Primitive obj = CertificateTools.getExtensionValue(x509Element, "1.3.6.1.4.1.8301.3.5");
        return (ValidityModel)ValidityModel.FACTORY.create((ASN1Encodable)obj);
    }

    public static boolean hasAnyPolicy(IX509Certificate certificate, ASN1ObjectIdentifier ... oids) throws IOException {
        ASN1Sequence derExplicitPolicies = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, CERTIFICATE_POLICIES);
        if (derExplicitPolicies == null) {
            return false;
        }
        if (derExplicitPolicies != null) {
            Enumeration e = derExplicitPolicies.getObjects();
            while (e.hasMoreElements()) {
                ASN1Encodable derPolicyInformation = (ASN1Encodable)e.nextElement();
                PolicyInformation policyInformation = PolicyInformation.getInstance((Object)derPolicyInformation);
                ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
                for (ASN1ObjectIdentifier oid : oids) {
                    if (!policyIdentifier.equals((ASN1Primitive)oid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int hashCode(IX509Certificate certificate) {
        try {
            return Arrays.hashCode((byte[])certificate.getEncoded());
        }
        catch (CertificateException e) {
            return 0;
        }
    }

    protected static boolean hasNotice(PolicyInformation policyInformation, String noticeRegex) {
        if (policyInformation == null) {
            return false;
        }
        ASN1Sequence derPolicyQualifiers = policyInformation.getPolicyQualifiers();
        if (derPolicyQualifiers == null) {
            return false;
        }
        Pattern noticePattern = Pattern.compile(noticeRegex);
        Enumeration en = derPolicyQualifiers.getObjects();
        while (en.hasMoreElements()) {
            String text;
            UserNotice notice;
            ASN1Encodable derPolicyQualifier = (ASN1Encodable)en.nextElement();
            PolicyQualifierInfo policyQualifierInfo = PolicyQualifierInfo.getInstance((Object)derPolicyQualifier);
            String id = policyQualifierInfo.getPolicyQualifierId().getId();
            if (!id_qt_unotice.equals(id) || (notice = UserNotice.getInstance((Object)policyQualifierInfo.getQualifier())).getExplicitText() == null || !noticePattern.matcher(text = notice.getExplicitText().getString()).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPolicy(IX509Certificate certificate, ASN1ObjectIdentifier oid) throws IOException {
        return CertificateTools.hasAnyPolicy(certificate, oid);
    }

    public static boolean hasPolicyAndNotice(IX509Certificate certificate, ASN1ObjectIdentifier oid, String noticeRegex) throws IOException, CertificateException {
        PolicyInformation policyInformation = CertificateTools.getPolicy(certificate, oid);
        if (policyInformation == null) {
            return false;
        }
        return CertificateTools.hasNotice(policyInformation, noticeRegex);
    }

    public static boolean hasPolicyNotice(IX509Certificate certificate, String noticeRegex) throws IOException, CertificateException {
        List<PolicyInformation> policies = CertificateTools.getPolicies(certificate);
        for (PolicyInformation policyInformation : policies) {
            if (!CertificateTools.hasNotice(policyInformation, noticeRegex)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPseudonym(X500Principal x500Principal) {
        X500SimpleName name = new X500SimpleName(x500Principal);
        return !StringTools.isEmpty((String)name.getPseudonym());
    }

    public static boolean isCA(IX509Certificate certificate) throws IOException {
        BasicConstraints basicConstraints = CertificateTools.getBasicConstraints(certificate);
        if (basicConstraints == null) {
            return false;
        }
        return basicConstraints.isCA();
    }

    public static boolean isCriticalExtension(X509Extension ext, String oid) {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return false;
        }
        Set<String> critExts = ext.getCriticalExtensionOIDs();
        if (critExts == null) {
            return false;
        }
        return critExts.contains(oid);
    }

    public static boolean isEndCA(IX509Certificate certificate) throws IOException {
        if (certificate instanceof IX509AttributeCertificate) {
            return false;
        }
        if (CertificateTools.isCA(certificate)) {
            return true;
        }
        KeyUsage keyUsage = CertificateTools.getKeyUsage(certificate);
        if (keyUsage == null) {
            return true;
        }
        if (keyUsage.hasUsages(2) || keyUsage.hasUsages(4)) {
            return true;
        }
        try {
            ExtendedKeyUsage extKeyUsage;
            ASN1Primitive derExtKeyUsage = CertificateTools.getExtensionValue(certificate, "2.5.29.37");
            if (derExtKeyUsage != null && (extKeyUsage = ExtendedKeyUsage.getInstance((Object)derExtKeyUsage)).hasKeyPurposeId(KeyPurposeId.id_kp_OCSPSigning)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isEndUserCertificate(IX509Certificate certificate) throws IOException {
        if (certificate instanceof IX509AttributeCertificate) {
            return true;
        }
        if (CertificateTools.isCA(certificate)) {
            return false;
        }
        KeyUsage keyUsage = CertificateTools.getKeyUsage(certificate);
        if (keyUsage == null) {
            return true;
        }
        if (keyUsage.hasUsages(128)) {
            return true;
        }
        if (keyUsage.hasUsages(2) || keyUsage.hasUsages(4)) {
            return false;
        }
        try {
            ExtendedKeyUsage extKeyUsage;
            ASN1Primitive derExtKeyUsage = CertificateTools.getExtensionValue(certificate, "2.5.29.37");
            if (derExtKeyUsage != null && ((extKeyUsage = ExtendedKeyUsage.getInstance((Object)derExtKeyUsage)).hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_OCSPSigning))) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isKeyPurposeAuthentication(IX509PublicKeyCertificate cert) throws IOException {
        ExtendedKeyUsage extKeyUsage = CertificateTools.getExtendedKeyUsage(cert);
        if (extKeyUsage == null) {
            return false;
        }
        return extKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_clientAuth) || extKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_serverAuth);
    }

    public static boolean isKeyPurposeEncryption(IX509PublicKeyCertificate certificate) throws IOException {
        KeyUsage keyUsage = CertificateTools.getKeyUsage(certificate);
        if (keyUsage == null) {
            return false;
        }
        return CertificateTools.isKeyPurposeEncryption(keyUsage);
    }

    private static boolean isKeyPurposeEncryption(KeyUsage keyUsage) {
        return keyUsage.hasUsages(16) || keyUsage.hasUsages(32) || keyUsage.hasUsages(1) || keyUsage.hasUsages(8);
    }

    public static boolean isKeyPurposeEncryptionOrAny(IX509PublicKeyCertificate certificate) throws IOException {
        KeyUsage keyUsage = CertificateTools.getKeyUsage(certificate);
        if (keyUsage == null) {
            return true;
        }
        return CertificateTools.isKeyPurposeEncryption(keyUsage);
    }

    public static boolean isSelfSigned(IX509Certificate certificate) {
        if (!(certificate instanceof IX509PublicKeyCertificate)) {
            return false;
        }
        return certificate.getSubjectX500Principal().equals(certificate.getIssuerX500Principal());
    }

    public static X500Principal parsePrincipal(de.intarsys.asn1.common.GeneralName name) throws IOException {
        OtherName otherName;
        if (name.isDirectoryName()) {
            RDNSequence rdnSeq = name.getDirectoryName().getRDNSequence();
            byte[] bytes = rdnSeq.getDEREncoded();
            try {
                X500Principal principal = new X500Principal(bytes);
                return principal;
            }
            catch (IllegalArgumentException e) {
                ASN1ValueHolder child;
                ASN1SequenceHolder sequence;
                if (rdnSeq.getValueHolder().isSequence() && (sequence = (ASN1SequenceHolder)rdnSeq.getValueHolder()).size() == 1 && (child = sequence.getChild(0)).isSequence()) {
                    bytes = child.toASN1Primitive().getEncoded();
                    X500Principal principal = new X500Principal(bytes);
                    return principal;
                }
                throw e;
            }
        }
        if (name.isOtherName() && (otherName = name.getOtherName()).getTypeId().equals("0.2.262.1.10.3.0")) {
            X500Principal principal = new X500Principal(ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{otherName.getValue()}));
            return principal;
        }
        return null;
    }

    public static X500Principal parsePrincipal(GeneralNames gn) throws IOException {
        X500Principal[] principals = CertificateTools.parsePrincipals(gn);
        if (principals == null || principals.length == 0) {
            return null;
        }
        return principals[0];
    }

    public static X500Principal parsePrincipal(GeneralName name) throws IOException {
        ASN1Sequence seq;
        ASN1ObjectIdentifier id;
        if (name.getTagNo() == 4) {
            byte[] bytes = name.getName().toASN1Primitive().getEncoded("DER");
            X500Principal principal = new X500Principal(bytes);
            return principal;
        }
        if (name.getTagNo() == 0 && (id = ASN1ObjectIdentifier.getInstance((Object)(seq = ASN1Sequence.getInstance((Object)name.getName())).getObjectAt(0))).getId().equals("0.2.262.1.10.3.0")) {
            ASN1TaggedObject value = ASN1TaggedObject.getInstance((Object)seq.getObjectAt(1));
            X500Principal principal = new X500Principal(value.getBaseObject().getEncoded("DER"));
            return principal;
        }
        return null;
    }

    public static X500Principal parsePrincipal(String directoryName) throws IOException {
        X500Name name = new X500Name(directoryName);
        return new X500Principal(name.getEncoded());
    }

    public static X500Principal[] parsePrincipals(GeneralNames gn) throws IOException {
        ArrayList<X500Principal> result = new ArrayList<X500Principal>();
        de.intarsys.asn1.common.GeneralName[] names = gn.getNames();
        for (int i = 0; i < names.length; ++i) {
            de.intarsys.asn1.common.GeneralName name = names[i];
            X500Principal principal = CertificateTools.parsePrincipal(name);
            if (principal == null) continue;
            result.add(principal);
        }
        return result.toArray(new X500Principal[result.size()]);
    }

    public static X500Principal[] parsePrincipals(org.bouncycastle.asn1.x509.GeneralNames gn) throws IOException {
        ArrayList<X500Principal> result = new ArrayList<X500Principal>();
        GeneralName[] names = gn.getNames();
        for (int i = 0; i < names.length; ++i) {
            GeneralName name = names[i];
            X500Principal principal = CertificateTools.parsePrincipal(name);
            if (principal == null) continue;
            result.add(principal);
        }
        return result.toArray(new X500Principal[result.size()]);
    }

    public static boolean[] parseUniqueId(DERBitString id) {
        if (id == null) {
            return null;
        }
        byte[] bytes = id.getBytes();
        boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
        for (int i = 0; i != boolId.length; ++i) {
            boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
        }
        return boolId;
    }

    public static void saveCertificate(IX509Certificate certificate, IActivity parent) {
        String filename = CertificateTools.getSubjectLabel(certificate);
        filename = FileTools.trimPath((String)filename);
        String path = RequestFile.requestFileSave(null, (String[])new String[]{"*.cer"}, null, null, (String)filename, (boolean)false);
        if (path == null) {
            return;
        }
        try {
            FileTools.write((File)new File(path), (byte[])certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            Reporter.get().reportError("Error", e.getMessage(), (Throwable)e, 0);
        }
        catch (IOException e) {
            Reporter.get().reportError("Error", e.getMessage(), (Throwable)e, 0);
        }
    }

    public static Iterator<IX509Certificate> selectCertificates(IX509CertificateFilter filter, Collection<? extends IX509Certificate> collection) {
        return filter == null ? collection.iterator() : new CertificateFilterIterator<IX509Certificate>(collection.iterator(), filter);
    }

    public static void setRecentLoadLocation(String path) {
        CertificateTools.setRecentLocation("load", path);
    }

    public static void setRecentLocation(String action, ILocator locator) {
        LocatorUsage.get().setLastLocator(action, LOCATOR_RECENTCONTEXT, locator);
    }

    public static void setRecentLocation(String action, String path) {
        CertificateTools.setRecentLocation(action, (ILocator)new FileLocator(path));
    }

    public static void setRecentSaveLocation(String path) {
        CertificateTools.setRecentLocation("save", path);
    }

    public static <T extends IX509PublicKeyCertificate> List<T> sortCertificates(Collection<T> certificates) {
        ArrayList<IX509PublicKeyCertificate> chain = new ArrayList<IX509PublicKeyCertificate>(certificates.size());
        for (IX509PublicKeyCertificate candidate : certificates) {
            boolean added = false;
            for (int i = 0; i < chain.size(); ++i) {
                IX509PublicKeyCertificate cert = (IX509PublicKeyCertificate)chain.get(i);
                if (candidate.getSubjectX500Principal().equals(cert.getIssuerX500Principal())) {
                    chain.add(i + 1, candidate);
                    added = true;
                    break;
                }
                if (!candidate.getIssuerX500Principal().equals(cert.getSubjectX500Principal())) continue;
                chain.add(i, candidate);
                added = true;
                break;
            }
            if (added) continue;
            chain.add(candidate);
        }
        return chain;
    }

    protected static List<IX509CertificateFilter> toAttributeCertificateSelectors(List<IX509CertificateFilter> list, Object value) throws IOException {
        if (value instanceof IX509CertificateFilter) {
            list.add((IX509CertificateFilter)value);
        } else if (value instanceof IX509CertificateFilter[]) {
            for (IX509CertificateFilter temp : (IX509CertificateFilter[])value) {
                CertificateTools.toAttributeCertificateSelectors(list, temp);
            }
        } else if (value instanceof IArgs) {
            for (IArgs.IBinding temp : (IArgs)value) {
                CertificateTools.toAttributeCertificateSelectors(list, temp.getValue());
            }
        } else if (value instanceof List) {
            for (Object temp : (List)value) {
                CertificateTools.toAttributeCertificateSelectors(list, temp);
            }
        } else if (value instanceof String) {
            X509CertificateSelectorSerializer serializer = new X509CertificateSelectorSerializer();
            list.addAll(serializer.deserializeList((String)value));
        }
        return list;
    }

    public static List<IX509CertificateFilter> toAttributeCertificateSelectors(Object value) throws IOException {
        return CertificateTools.toAttributeCertificateSelectors(new ArrayList<IX509CertificateFilter>(), value);
    }

    public static X509CertificateHolder[] toCertificateHolders(IX509PublicKeyCertificate[] certs) throws CertificateException, IOException {
        if (certs == null) {
            return null;
        }
        X509CertificateHolder[] result = new X509CertificateHolder[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            IX509PublicKeyCertificate jdkCert = certs[i];
            result[i] = new X509CertificateHolder(jdkCert.getEncoded());
        }
        return result;
    }

    public static X509Certificate[] toJavaCerts(IX509Certificate[] certs) throws CertificateException {
        if (certs == null) {
            return null;
        }
        X509Certificate[] result = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            IX509PublicKeyCertificate jdkCert = (IX509PublicKeyCertificate)certs[i];
            result[i] = jdkCert.toJavaCertificate();
        }
        return result;
    }

    public static String toString(de.intarsys.asn1.common.GeneralName generalName) {
        if (generalName == null) {
            return null;
        }
        ASN1Primitive object = generalName.toASN1Primitive();
        GeneralName name = GeneralName.getInstance((Object)object);
        return CertificateTools.toString(name);
    }

    public static String toString(GeneralName name) {
        if (name == null) {
            return null;
        }
        ASN1Encodable obj = name.getName();
        switch (name.getTagNo()) {
            case 4: {
                try {
                    X500Principal p = new X500Principal(obj.toASN1Primitive().getEncoded("DER"));
                    return p.toString();
                }
                catch (IOException e) {
                    return obj.toString();
                }
            }
            case 2: {
                return ((DERIA5String)obj).getString();
            }
            case 5: {
                EDIPartyName partyName = (EDIPartyName)EDIPartyName.FACTORY.create(obj);
                StringBuilder sb = new StringBuilder();
                if (partyName.getNameAssigner() != null) {
                    sb.append(partyName.getNameAssigner().getString()).append(" / ");
                }
                sb.append(partyName.getPartyName().getString());
                return sb.toString();
            }
            case 7: {
                byte[] ints = ((DEROctetString)obj).getOctets();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < ints.length; ++i) {
                    sb.append(ints[i] & 0xFF);
                    if (i >= ints.length - 1) continue;
                    sb.append(".");
                }
                return sb.toString();
            }
            case 0: {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)name.getName());
                ASN1ObjectIdentifier id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0));
                if (!id.getId().equals("0.2.262.1.10.3.0")) break;
                try {
                    ASN1TaggedObject value = ASN1TaggedObject.getInstance((Object)seq.getObjectAt(1));
                    X500Principal principal = new X500Principal(value.getBaseObject().getEncoded("DER"));
                    return principal.toString();
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 8: {
                return ((ASN1ObjectIdentifier)obj).getId();
            }
            case 1: {
                return ((DERIA5String)obj).getString();
            }
            case 6: {
                return ((DERIA5String)obj).getString();
            }
            case 3: {
                return ((DERIA5String)obj).getString();
            }
        }
        try {
            return "#" + HexTools.bytesToHexString((byte[])obj.toASN1Primitive().getEncoded("DER"));
        }
        catch (IOException e) {
            return obj.toString();
        }
    }

    public static Set<String> toStringIdentifiers(Set<ASN1ObjectIdentifier> asn1Identifiers) {
        if (asn1Identifiers == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (ASN1ObjectIdentifier asn1Identifier : asn1Identifiers) {
            result.add(asn1Identifier.getId());
        }
        return result;
    }

    public static ASN1Primitive unwrapExtensionValue(byte[] extensionValue) throws IOException {
        ASN1OctetString octs = (ASN1OctetString)ASN1Tools.create((byte[])extensionValue);
        return ASN1Tools.create((byte[])octs.getOctets());
    }

    public static IX509PublicKeyCertificate wrapCertificateHolder(X509CertificateHolder certHolder) throws IOException, CertificateException {
        if (certHolder == null) {
            return null;
        }
        return X509CertificateFactory.get().createPublicKeyCertificate(certHolder.getEncoded());
    }

    public static IX509PublicKeyCertificate[] wrapCertificateHolders(X509CertificateHolder[] certHolders) throws CertificateException, IOException {
        if (certHolders == null) {
            return null;
        }
        IX509PublicKeyCertificate[] result = new IX509PublicKeyCertificate[certHolders.length];
        for (int i = 0; i < certHolders.length; ++i) {
            X509CertificateHolder jdkCert = certHolders[i];
            result[i] = CertificateTools.wrapCertificateHolder(jdkCert);
        }
        return result;
    }

    public static IX509PublicKeyCertificate wrapJavaCert(X509Certificate jdkCert) {
        if (jdkCert == null) {
            return null;
        }
        return X509CertificateFactory.get().createPublicKeyCertificate(jdkCert);
    }

    public static IX509PublicKeyCertificate[] wrapJavaCerts(X509Certificate[] jdkCerts) {
        if (jdkCerts == null) {
            return null;
        }
        IX509PublicKeyCertificate[] result = new IX509PublicKeyCertificate[jdkCerts.length];
        for (int i = 0; i < jdkCerts.length; ++i) {
            X509Certificate jdkCert = jdkCerts[i];
            result[i] = CertificateTools.wrapJavaCert(jdkCert);
        }
        return result;
    }

    public static IX509CRL wrapJavaCRL(X509CRL jdkCRL) {
        if (jdkCRL == null) {
            return null;
        }
        return X509CertificateFactory.get().createCRL(jdkCRL);
    }

    public static <S, R> Collection<R> wrapJavaObjects(Collection<S> objects) {
        if (objects == null) {
            return null;
        }
        HashSet<X509Extension> result = new HashSet<X509Extension>();
        for (S element : objects) {
            if (element instanceof X509Certificate) {
                result.add(CertificateTools.wrapJavaCert((X509Certificate)element));
                continue;
            }
            if (!(element instanceof X509CRL)) continue;
            result.add(CertificateTools.wrapJavaCRL((X509CRL)element));
        }
        return result;
    }

    private static class ComparableCertificate {
        private final IX509Certificate certificate;

        public ComparableCertificate(IX509Certificate certificate) {
            this.certificate = certificate;
        }

        public boolean equals(Object obj) {
            return CertificateTools.equals(this.certificate, obj);
        }

        public IX509Certificate getCertificate() {
            return this.certificate;
        }

        public int hashCode() {
            return CertificateTools.hashCode(this.certificate);
        }
    }
}

