/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.pkcs1;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.BasicSignatureEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.signature.EncodedSignatureEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSMathematicalSignature;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.IllegalBlockSizeException;

public class EncodedSignatureEntryValidator
extends BasicSignatureEntryValidator {
    @Override
    public IVSSignatureEntry validate(ISignatureEntry signatureEntry, IDigest digest, IValidationParameters parameters) {
        EncodedSignatureEntry encodedSignatureEntry = (EncodedSignatureEntry)signatureEntry;
        VSSignature signatureState = new VSSignature(digest);
        VSDigest digestState = new VSDigest();
        if (digest != null) {
            digestState.setCalculatedDigest(digest.getBytes());
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(digest.getAlgorithmName());
            AlgorithmSpec<DigestAlgorithm> digestAlgorithmSpec = new AlgorithmSpec<DigestAlgorithm>(digestAlgorithm);
            digestState.setAlgorithmSpec(digestAlgorithmSpec);
        }
        VSMathematicalSignature sigState = new VSMathematicalSignature();
        sigState.setSignature(encodedSignatureEntry.getSignatureEncoded());
        sigState.setSignatureAlgorithmSpec(encodedSignatureEntry.getSignatureAlgorithmSpec());
        sigState.setHashAlgorithmSpec(encodedSignatureEntry.getHashAlgorithmSpec());
        if (digest != null) {
            try {
                boolean valid = this.verifyDigest(encodedSignatureEntry, digest);
                if (valid) {
                    digestState.increaseState(0);
                    digestState.addMessage(CommonValidationMessages.INFO_DIGEST_VERIFIED_TRUE());
                    sigState.increaseState(0);
                    sigState.addMessage(CommonValidationMessages.INFO_SIGNATURE_VERIFIED_TRUE());
                } else {
                    sigState.invalidate(CommonValidationMessages.ERROR_SIGNATURE_VERIFIED_FALSE());
                    digestState.invalidate(CommonValidationMessages.ERROR_DIGEST_VERIFIED_FALSE());
                }
            }
            catch (NoSuchAlgorithmException e) {
                IValidationMessage msg = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN(e, e.getMessage());
                digestState.invalidate(msg);
                sigState.invalidate(msg);
            }
            catch (IllegalBlockSizeException e) {
                IValidationMessage msg = CommonValidationMessages.ERROR_ILLEGAL_BLOCK_SIZE(e);
                digestState.invalidate(msg);
                sigState.invalidate(msg);
            }
            catch (IOException e) {
                IValidationMessage msg = CommonValidationMessages.ERROR_PADDING_BAD(e);
                digestState.invalidate(msg);
                sigState.invalidate(msg);
            }
            catch (IllegalArgumentException e) {
                IValidationMessage msg = CommonValidationMessages.ERROR_DATA_BAD(e.getLocalizedMessage());
                digestState.invalidate(msg);
                sigState.invalidate(msg);
            }
            catch (GeneralSecurityException e) {
                IValidationMessage msg = CommonValidationMessages.ERROR_DATA_BAD(e.getLocalizedMessage());
                digestState.invalidate(msg);
                sigState.invalidate(msg);
            }
        }
        signatureState.addDigestState(digestState);
        if (digestState.isUndefined()) {
            signatureState.increaseState(2);
        }
        signatureState.setSignatureState(sigState);
        VSSignatureEntry state = new VSSignatureEntry(encodedSignatureEntry);
        state.setSignatureState(signatureState);
        return state;
    }

    protected boolean verifyDigest(EncodedSignatureEntry encodedSigatureEntry, IDigest digest) throws IOException, GeneralSecurityException {
        IX509PublicKeyCertificate signerCertificate = encodedSigatureEntry.getSignerCertificate();
        if (signerCertificate == null) {
            return false;
        }
        PublicKey key = signerCertificate.getPublicKey();
        AlgorithmSpec<SignatureAlgorithm> algorithmSpec = encodedSigatureEntry.getSignatureAlgorithmSpec();
        byte[] encodedSignature = encodedSigatureEntry.getSignatureEncoded();
        if (algorithmSpec != null && algorithmSpec.getAlgorithm().getEncodingAlgorithm() == EncodingAlgorithm.ALG_PSS) {
            Signature jceSignature = Signature.getInstance("RAWRSASSA-PSS", "BC");
            jceSignature.setParameter(algorithmSpec.getParameterSpec());
            jceSignature.initVerify(key);
            jceSignature.update(digest.getBytes());
            return jceSignature.verify(encodedSignature);
        }
        byte[] encodedDigest = digest.getEncoded();
        return PpkTools.validate(encodedSignature, key, algorithmSpec == null ? null : algorithmSpec.getParameterSpec(), encodedDigest);
    }
}

