/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes;

import de.intarsys.security.app.validation.CommonValidationContextDecorator;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationContextDecorator;
import de.intarsys.security.app.validation.ValidationContextDecoratorRegistry;
import de.intarsys.security.app.validation.commonpki.ValidationContextProxy;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.info.X500PrincipalInfo;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.commonpki.CryptoDates;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QESValidationContextDecorator
extends CommonValidationContextDecorator {
    private static final Logger Log = LoggerFactory.getLogger(QESValidationContextDecorator.class);

    protected IValidationContext basicDecorate(IValidationContext context, IArgs args) {
        ValidationContextProxy myContext = new ValidationContextProxy(context);
        myContext.setCertificateValidator((certificate, params) -> {
            String profileId = this.getProfile(certificate);
            IValidationContext profileContext = this.getProfileContext(profileId, args, context);
            return profileContext.getCertificateValidator().validate(certificate, params);
        });
        myContext.setSignatureEntryValidator((signatureEntry, digest, parameters) -> {
            String profileId = this.getProfile((ISignatureEntry)signatureEntry);
            IValidationContext profileContext = this.getProfileContext(profileId, args, context);
            return (IVSSignatureEntry)profileContext.getSignatureEntryValidator().validate(signatureEntry, digest, parameters);
        });
        myContext.setTimestampValidator((timestamp, digest, parameters) -> {
            String profileId = this.getProfile(timestamp);
            IValidationContext profileContext = this.getProfileContext(profileId, args, context);
            return profileContext.getTimestampValidator().validate(timestamp, digest, parameters);
        });
        myContext.setOCSPService((certificate, certificatePath, params) -> {
            String profileId = this.getProfile(certificate);
            IValidationContext profileContext = this.getProfileContext(profileId, args, context);
            return profileContext.getOCSPService().validateCertificate(certificate, certificatePath, params);
        });
        return myContext;
    }

    @Override
    public IValidationContext decorate(IValidationContext context, IArgs args) {
        if (CommonPKIProfile.get(args) == CommonPKIProfile.QES_Auto) {
            return this.basicDecorate(context, args);
        }
        return context;
    }

    protected Date getGenerationDate(IX509Certificate certificate) {
        try {
            ASN1Primitive derDateOfCertGen = CertificateTools.getExtensionValue(certificate, "1.3.36.8.3.1");
            ASN1GeneralizedTime dateOfCertGen = ASN1GeneralizedTime.getInstance((Object)derDateOfCertGen);
            if (dateOfCertGen != null) {
                return dateOfCertGen.getDate();
            }
        }
        catch (IOException | ParseException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return certificate.getNotBefore();
    }

    protected String getIssuerCountry(IX509Certificate certificate) {
        X500PrincipalInfo issuerPrincipal = new X500PrincipalInfo(certificate.getIssuerX500Principal());
        return issuerPrincipal.getCountry();
    }

    protected String getProfile(ISignatureEntry signatureEntry) {
        IX509PublicKeyCertificate certificate = null;
        try {
            certificate = signatureEntry.getSignerCertificate();
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (certificate == null) {
            return CommonPKIProfile.QES_Basic.getId();
        }
        String issuerCountry = this.getIssuerCountry(certificate);
        return this.getProfile(issuerCountry, () -> {
            Date creationTime = signatureEntry.getCreationDate();
            if (creationTime == null) {
                creationTime = new Date();
            }
            return creationTime;
        });
    }

    protected String getProfile(ITimestampToken timestamp) {
        Iterator<?> entries;
        ISignatureContainer<?> signatureContainer = timestamp.getSignatureContainer();
        if (signatureContainer != null && (entries = signatureContainer.getEntries().iterator()).hasNext()) {
            ISignatureEntry signatureEntry = (ISignatureEntry)entries.next();
            return this.getProfile(signatureEntry);
        }
        return CommonPKIProfile.QES_Basic.getId();
    }

    protected String getProfile(IX509Certificate certificate) {
        String issuerCountry = this.getIssuerCountry(certificate);
        return this.getProfile(issuerCountry, () -> this.getGenerationDate(certificate));
    }

    protected String getProfile(String domain, Supplier<Date> date) {
        if ("de".equalsIgnoreCase(domain) && date.get().before(CryptoDates.END_OF_SIGG)) {
            return CommonPKIProfile.QES_SigG.getId();
        }
        return CommonPKIProfile.QES_Basic.getId();
    }

    protected IValidationContext getProfileContext(String profileId, IArgs args, IValidationContext baseContext) {
        IValidationContext profileContext = null;
        String attr = "PROFILE_" + profileId;
        if (baseContext instanceof IAttributeSupport) {
            profileContext = (IValidationContext)((IAttributeSupport)baseContext).getAttribute((Object)attr);
        }
        if (profileContext == null) {
            IValidationContextDecorator profileDecorator = ValidationContextDecoratorRegistry.get().lookupDecorator(profileId);
            args = args.copy();
            args.put("qualificationProfile", (Object)profileId);
            profileContext = profileDecorator.decorate(baseContext, args);
            if (baseContext instanceof IAttributeSupport) {
                ((IAttributeSupport)baseContext).setAttribute((Object)attr, (Object)profileContext);
            }
        }
        return profileContext;
    }
}

