/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.crypto;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.common.ValidationStateWalker;
import de.intarsys.security.app.validation.commonpki.crypto.PACKAGE;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.VSCrypto;
import de.intarsys.security.standard.validation.ValidationAspect;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.standard.validation.commonpki.CryptoDates;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCrypto;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSMathematicalSignature;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.security.validation.IValidationAspect;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.IMessageBundle;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Optional;

public class CryptoValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    private final int severity;

    public CryptoValidator() {
        this(0);
    }

    public CryptoValidator(int severity) {
        this.severity = severity;
    }

    protected void checkDigestAlgorithmQuality(Date sigDate, String digestAlgorithm, String expirationAlgorithm, Date expirationDate, VSCrypto cryptoState) {
        if (expirationAlgorithm.equals(digestAlgorithm)) {
            if (sigDate.after(expirationDate)) {
                String formattedDate = FORMATTER.format(DateTools.toLocalDate((Date)expirationDate));
                cryptoState.invalidate(Msg.getString("QESSigGSignatureEntryReviewer.signature.SigDigestAlgorithmExpired", new Object[]{digestAlgorithm, formattedDate}));
            } else if (DateEnvironment.get().now().after(expirationDate)) {
                String formattedDate = FORMATTER.format(DateTools.toLocalDate((Date)expirationDate));
                Object message = Msg.getString("QESSigGSignatureEntryReviewer.signature.SigDigestAlgorithmExpired", new Object[]{digestAlgorithm, formattedDate});
                message = (String)message + " " + Msg.getString("QESSigGSignatureEntryReviewer.signature.ReducedAuthenticity", new Object[0]);
                cryptoState.addMessage(ValidationMessage.createWarning((String)message));
            }
        }
    }

    protected void checkDigestAlgorithmQuality(IVSDigest digestState, VSCrypto cryptoState, Date sigDate) {
        String digestAlgorithm = ((Algorithm)digestState.getAlgorithmSpec().getAlgorithm()).getCanonicalName();
        this.checkDigestAlgorithmQuality(sigDate, digestAlgorithm, DigestAlgorithm.ALG_SHA1.getCanonicalName(), CryptoDates.EXPIRATIONDATE_SIG_DIGEST_SHA1, cryptoState);
        this.checkDigestAlgorithmQuality(sigDate, digestAlgorithm, "RIPEMD160", CryptoDates.EXPIRATIONDATE_SIG_DIGEST_RIPEMD160, cryptoState);
    }

    protected void checkDigestAlgorithmQuality(IVSSignatureEntry state, VSCrypto cryptoState, Date sigDate) {
        IVSSignature sigState = state.getSignatureState();
        if (sigState != null) {
            for (IVSDigest digestState : sigState.getDigestStates()) {
                this.checkDigestAlgorithmQuality(digestState, cryptoState, sigDate);
            }
        }
    }

    protected void checkECDSAKeySize(Date sigDate, int keyBitSize, VSCrypto cryptoState) {
        if (keyBitSize < 0) {
            String msg = Msg.getString("QESSigGSignatureEntryReviewer.ErrorReadingKeysize", new Object[0]);
            cryptoState.invalidate(ValidationMessage.createError(msg));
        } else {
            Date expirationDate = CryptoDates.getExpirationDateForECDSAKeySize(keyBitSize);
            if (sigDate.after(expirationDate)) {
                String message = Msg.getString("QESSigGSignatureEntryReviewer.signature.ECDSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                cryptoState.invalidate(message);
            } else if (DateEnvironment.get().now().after(expirationDate)) {
                Object message = Msg.getString("QESSigGSignatureEntryReviewer.signature.ECDSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                message = (String)message + " " + Msg.getString("QESSigGSignatureEntryReviewer.signature.ReducedAuthenticity", new Object[0]);
                cryptoState.addMessage(ValidationMessage.createWarning((String)message));
            }
        }
    }

    protected void checkRSAKeySize(Date sigDate, int keyBitSize, VSCrypto cryptoState) {
        if (keyBitSize < 0) {
            String msg = Msg.getString("QESSigGSignatureEntryReviewer.ErrorReadingKeysize", new Object[0]);
            cryptoState.invalidate(ValidationMessage.createError(msg));
        } else if (keyBitSize < 1024) {
            cryptoState.invalidate(Msg.getString("QESSigGSignatureEntryReviewer.signature.RSAKeySizeTooShort", new Object[]{String.valueOf(keyBitSize)}));
        } else {
            Date expirationDate = CryptoDates.getExpirationDateForRSAKeySize(keyBitSize);
            if (sigDate.after(expirationDate)) {
                String message = Msg.getString("QESSigGSignatureEntryReviewer.signature.RSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                cryptoState.invalidate(message);
            } else if (DateEnvironment.get().now().after(expirationDate)) {
                Object message = Msg.getString("QESSigGSignatureEntryReviewer.signature.RSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                message = (String)message + " " + Msg.getString("QESSigGSignatureEntryReviewer.signature.ReducedAuthenticity", new Object[0]);
                cryptoState.addMessage(ValidationMessage.createWarning((String)message));
            }
        }
    }

    protected void checkSignatureAlgorithmQuality(IVSSignatureEntry state, VSCrypto cryptoState, Date sigDate) {
        SignatureAlgorithm signatureAlgorithm;
        IVSMathematicalSignature sigState = state.getSignatureState().getSignatureState();
        if (sigState != null && (signatureAlgorithm = sigState.getSignatureAlgorithmSpec().getAlgorithm()).getEncryptionAlgorithm() == EncryptionAlgorithm.ALG_RSA) {
            Date expirationDate;
            EncodingAlgorithm encodingAlgorithm = signatureAlgorithm.getEncodingAlgorithm();
            if (encodingAlgorithm == EncodingAlgorithm.ALG_UNKNOWN) {
                cryptoState.increaseState(2);
                cryptoState.addMessage(ValidationMessage.createError(Msg.getString("QESSigGSignatureEntryReviewer.signature.SigEncodingSchemaUnknown", new Object[0])));
            } else if ((encodingAlgorithm == EncodingAlgorithm.ALG_PKCS1Type1 || encodingAlgorithm == EncodingAlgorithm.ALG_PKCS1Type2) && sigDate.after(expirationDate = CryptoDates.EXPIRATIONDATE_SIG_RSA_PKCS1_v1_5)) {
                String formattedDate = FORMATTER.format(DateTools.toLocalDate((Date)expirationDate));
                cryptoState.invalidate(Msg.getString("QESSigGSignatureEntryReviewer.signature.SigEncodingSchemaExpired", new Object[]{encodingAlgorithm.getName(), formattedDate}));
            }
        }
    }

    protected VSCrypto createInitialState(IValidationState state) {
        VSCrypto cryptoState = new VSCrypto(state.getValidationTarget(), 0);
        cryptoState.setSeverity(1);
        return cryptoState;
    }

    public int getSeverity() {
        return this.severity;
    }

    public IVSCrypto validate(IValidationState state, final Date referenceDate) {
        ValidationStateWalker walker = new ValidationStateWalker(){

            @Override
            public void visit(IVSSignatureEntry state) {
                IVSCrypto cryptoState = CryptoValidator.this.validate(state, referenceDate);
                ((CommonValidationState)((Object)state)).addAspect(ValidationAspect.with(IVSCrypto.class, (IValidationState)cryptoState));
                super.visit(state);
            }

            @Override
            public void visit(IVSTimestamp state) {
                IVSCrypto cryptoState = CryptoValidator.this.validate(state, referenceDate);
                ((CommonValidationState)((Object)state)).addAspect(ValidationAspect.with(IVSCrypto.class, (IValidationState)cryptoState));
                super.visit(state);
            }

            @Override
            public void visit(IVSTimestampEntry state) {
                super.visit(state);
                IValidationAspect aspect = state.getTimestampState().getAspect(IVSCrypto.class.getName());
                ((CommonValidationState)((Object)state)).addAspect(aspect);
            }
        };
        walker.visit(state);
        IValidationAspect aspect = state.getAspect(IVSCrypto.class.getName());
        return Optional.ofNullable(aspect).map(a -> (IVSCrypto)a.getState()).orElseGet(() -> new VSCrypto(-1));
    }

    protected IVSCrypto validate(IVSSignatureEntry state, Date referenceDate) {
        VSCrypto cryptoState = this.createInitialState(state);
        this.checkDigestAlgorithmQuality(state, cryptoState, referenceDate);
        this.checkSignatureAlgorithmQuality(state, cryptoState, referenceDate);
        IVSCertificate certState = state.getCertificateState();
        if (certState != null) {
            IX509PublicKeyCertificate signerCertificate = null;
            if (certState.getValidationTarget() != null) {
                signerCertificate = (IX509PublicKeyCertificate)certState.getValidationTarget().getImpl();
            }
            if (signerCertificate != null) {
                int keyBitSize = signerCertificate.getKeyBitSize();
                String algorithm = signerCertificate.getPublicKey().getAlgorithm();
                if ("RSA".equals(algorithm)) {
                    this.checkRSAKeySize(referenceDate, keyBitSize, cryptoState);
                } else if ("ECDSA".equals(algorithm) || "EC".equals(algorithm)) {
                    this.checkECDSAKeySize(referenceDate, keyBitSize, cryptoState);
                }
            }
        }
        return cryptoState;
    }

    protected IVSCrypto validate(IVSTimestamp state, Date referenceDate) {
        VSCrypto cryptoState = this.createInitialState(state);
        IVSDigest digestState = state.getDigestState();
        if (digestState != null) {
            this.checkDigestAlgorithmQuality(digestState, cryptoState, referenceDate);
        }
        return cryptoState;
    }
}

