/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.ades;

import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.ades.AdESLTVValidator;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.etsi.api.ConformanceLevel;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.ValidationAspect;
import de.intarsys.security.validation.IVSAdESLTV;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationState;

public class AdESLTVSignatureContainerEntryReviewer
implements IReviewer<ISignatureContainerEntry, IVSSignatureContainerEntry> {
    private AdESLTVValidator validator;

    public AdESLTVSignatureContainerEntryReviewer(AdESLTVValidator validator) {
        this.validator = validator;
    }

    private ConformanceLevel evaluateConformanceLevel(IVSAdESLTV ltvState, boolean hasValidTimestamp) {
        boolean hasValidLTVState = ltvState.isValid();
        if (hasValidLTVState && hasValidTimestamp) {
            return ConformanceLevel.LT;
        }
        if (hasValidTimestamp) {
            return ConformanceLevel.T;
        }
        if (hasValidLTVState) {
            return ConformanceLevel.V;
        }
        return ConformanceLevel.B;
    }

    public synchronized AdESLTVValidator getValidator() {
        if (this.validator == null) {
            this.validator = new AdESLTVValidator();
        }
        return this.validator;
    }

    @Override
    public IVSSignatureContainerEntry review(ISignatureContainerEntry entry, IVSSignatureContainerEntry state, IValidationParameters params) {
        IVSSignatureEntry signatureEntry;
        if (entry == null || state == null) {
            return state;
        }
        IVSAdESLTV ltvState = this.getValidator().validate(state);
        ((CommonValidationState)((Object)state)).addAspect(ValidationAspect.with(IVSAdESLTV.class, (IValidationState)ltvState));
        boolean hasValidTimestamp = state instanceof IVSSignatureEntry && (signatureEntry = (IVSSignatureEntry)state).getTimestampStates().stream().anyMatch(IValidationState::isValid);
        ConformanceLevel conformanceLevel = this.evaluateConformanceLevel(ltvState, hasValidTimestamp);
        ((CommonValidationState)((Object)state)).addAspect(ValidationAspect.with(IVSAdESLTV.class, (IValidationState)ltvState));
        ((CommonValidationState)((Object)state)).addAdditionalInfoObject((Object)conformanceLevel);
        return state;
    }
}

