/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.ICertificateValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ExtendedSignatureEntryValidator;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.attribute.IAttributeCertificatesAttribute;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.security.signature.attribute.ICertificateValuesAttribute;
import de.intarsys.security.signature.attribute.IRevocationValuesAttribute;
import de.intarsys.security.signature.attribute.ISignatureTimestampAttribute;
import de.intarsys.security.signature.attribute.ISignerAttributesAttribute;
import de.intarsys.security.signature.attribute.ISignerAttributesV2Attribute;
import de.intarsys.security.signature.attribute.ISigningCertificate;
import de.intarsys.security.signature.attribute.ISigningCertificateAttribute;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.CompositeValidationData;
import de.intarsys.security.standard.validation.ExtendedValidationData;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationDataSupport;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPKISignatureEntryValidator
extends ExtendedSignatureEntryValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CommonPKISignatureEntryValidator.class);
    private boolean validateTimestamps = true;
    private boolean validateCertificates = true;

    protected static List<IX509AttributeCertificate> getAttributeCertificates(ISignatureEntry entry) throws IOException {
        IAttributeMap signedAttributes = entry.getSignedAttributes();
        ISignerAttributesV2Attribute signerAttributesV2Attribute = (ISignerAttributesV2Attribute)signedAttributes.get("0.4.0.19122.1.1");
        if (signerAttributesV2Attribute != null) {
            return Arrays.asList(signerAttributesV2Attribute.getCertifiedAttributes());
        }
        ISignerAttributesAttribute signerAttributesAttribute = (ISignerAttributesAttribute)signedAttributes.get("1.2.840.113549.1.9.16.2.18");
        if (signerAttributesAttribute != null) {
            return Arrays.asList(signerAttributesAttribute.getCertifiedAttributes());
        }
        IAttributeCertificatesAttribute attributeCertificatesAttribute = (IAttributeCertificatesAttribute)signedAttributes.get("2.5.4.58");
        if (attributeCertificatesAttribute != null) {
            return Arrays.asList(attributeCertificatesAttribute.getAttributeCertificates());
        }
        return Collections.emptyList();
    }

    protected static IExtendedValidationData getExtendedValidationData(ISignatureEntry signatureEntry, IValidationParameters parameters) throws IOException {
        IExtendedValidationData paramData = parameters.getExtendedValidationData();
        IExtendedValidationData entryData = CommonPKISignatureEntryValidator.getExtendedValidationDataFromEntry(signatureEntry);
        IExtendedValidationData attributeData = CommonPKISignatureEntryValidator.getExtendedValidationDataFromAttributes(signatureEntry);
        IExtendedValidationData validationData = CommonPKISignatureEntryValidator.mergeValidationData(paramData, entryData, attributeData);
        return validationData;
    }

    protected static IExtendedValidationData getExtendedValidationDataFromAttributes(ISignatureEntry signatureEntry) throws IOException {
        IOCSPResponse[] ocsps;
        IX509CRL[] crls;
        IAttributeMap ua = signatureEntry.getUnsignedAttributes();
        IAttributeMap sa = signatureEntry.getSignedAttributes();
        ICertificateValuesAttribute certificateValuesAttribute = null;
        try {
            certificateValuesAttribute = (ICertificateValuesAttribute)ua.get("1.2.840.113549.1.9.16.2.23");
        }
        catch (Exception e) {
            Log.warn("Error decoding certificate-values attribute: " + e.getMessage(), (Throwable)e);
        }
        IX509PublicKeyCertificate[] certificates = certificateValuesAttribute != null ? certificateValuesAttribute.getCertificateValues() : new IX509PublicKeyCertificate[]{};
        IRevocationValuesAttribute revocationValuesAttribute = null;
        try {
            revocationValuesAttribute = (IRevocationValuesAttribute)ua.get("1.2.840.113549.1.9.16.2.24");
        }
        catch (Exception e) {
            Log.warn("Error decoding revocation-values attribute: " + e.getMessage(), (Throwable)e);
        }
        if (revocationValuesAttribute == null) {
            try {
                revocationValuesAttribute = (IRevocationValuesAttribute)sa.get("1.2.840.113583.1.1.8");
            }
            catch (Exception e) {
                Log.warn("Error decoding adbe-revocationInfoArchival attribute: " + e.getMessage(), (Throwable)e);
            }
        }
        if (revocationValuesAttribute == null) {
            crls = new IX509CRL[]{};
            ocsps = new IOCSPResponse[]{};
        } else {
            crls = revocationValuesAttribute.getCRLs();
            ocsps = revocationValuesAttribute.getOCSPs();
        }
        return new ExtendedValidationData(crls, ocsps, certificates);
    }

    protected static IExtendedValidationData getExtendedValidationDataFromEntry(ISignatureEntry signatureEntry) throws IOException {
        IExtendedValidationDataSupport dataSupport = (IExtendedValidationDataSupport)AdapterTools.getAdapter((Object)signatureEntry, IExtendedValidationDataSupport.class, null);
        if (dataSupport == null) {
            return null;
        }
        return dataSupport.getExtendedValidationData();
    }

    protected static IExtendedValidationData mergeValidationData(IExtendedValidationData ... data) {
        CompositeValidationData result = new CompositeValidationData();
        for (IExtendedValidationData dataItem : data) {
            if (dataItem == null) continue;
            result.addElement(dataItem);
        }
        List<IExtendedValidationData> elements = result.getElements();
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return result;
    }

    public CommonPKISignatureEntryValidator(IArgs args) {
        super(args);
    }

    @Override
    protected void basicValidate(ISignatureEntry entry, VSSignatureEntry entryState, IValidationParameters parameters) {
        IExtendedValidationData validationData = null;
        try {
            validationData = CommonPKISignatureEntryValidator.getExtendedValidationData(entry, parameters);
        }
        catch (IOException e) {
            IValidationMessage msg = CommonValidationMessages.ERROR_CERTIFICATE(e);
            entryState.setCertificateState(VSCertificate.createInvalid(msg));
            return;
        }
        if (validationData != null) {
            ValidationParameters augmentedParameters = ValidationParameters.copy(parameters);
            augmentedParameters.setExtendedValidationData(validationData);
            parameters = augmentedParameters;
        }
        if (this.isValidateTimestamps()) {
            this.validateTimestamps(entry, entryState, parameters);
        }
        if (this.isValidateCertificates()) {
            this.validateCertificates(entry, entryState, parameters);
        }
    }

    private IVSCertificate checkSignerCertificateIntegrity(IX509PublicKeyCertificate signer, IAttributeMap signedAttributes, IVSCertificate certificateState) {
        ISigningCertificate[] sigCerts;
        ISigningCertificateAttribute signingCertAttr = null;
        try {
            signingCertAttr = (ISigningCertificateAttribute)signedAttributes.get("1.2.840.113549.1.9.16.2.47");
            if (signingCertAttr == null) {
                signingCertAttr = (ISigningCertificateAttribute)signedAttributes.get("1.2.840.113549.1.9.16.2.12");
            }
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            VSCertificate state = new VSCertificate(certificateState);
            state.invalidate(CommonValidationMessages.ERROR_IO(e));
            return state;
        }
        if (signingCertAttr != null && (sigCerts = signingCertAttr.getSigningCertificates()) != null && sigCerts.length > 0) {
            ISigningCertificate sigCert = sigCerts[0];
            VSCertificate state = new VSCertificate(certificateState);
            IDigest expectedDigest = sigCert.getDigest();
            try {
                IDigester digester = DigestTools.createDigester((String)expectedDigest.getAlgorithmName());
                IDigest digest = digester.digest(signer.getEncoded());
                if (!digest.equals(expectedDigest)) {
                    state.invalidate(Msg.getString("CommonPKISignatureEntryValidator.SignerCertificateDigestCorrupt", new Object[0]));
                }
            }
            catch (NoSuchAlgorithmException e) {
                state.invalidate(CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN(e, expectedDigest.getAlgorithmName()));
            }
            catch (CertificateEncodingException e) {
                state.invalidate(CommonValidationMessages.ERROR_CERTIFICATE(e));
            }
            return state;
        }
        return certificateState;
    }

    public boolean isValidateCertificates() {
        return this.validateCertificates;
    }

    public boolean isValidateTimestamps() {
        return this.validateTimestamps;
    }

    public void setValidateCertificates(boolean pValidateCertificates) {
        this.validateCertificates = pValidateCertificates;
    }

    public void setValidateTimestamps(boolean validateTimestamps) {
        this.validateTimestamps = validateTimestamps;
    }

    private List<IVSCertificate> validateAttributeCertificates(List<IX509AttributeCertificate> attributes, IX509PublicKeyCertificate signer, IValidationParameters parameters) {
        if (attributes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IVSCertificate> attributeStates = new ArrayList<IVSCertificate>(attributes.size());
        for (IX509AttributeCertificate attribute : attributes) {
            IVSCertificate state = null;
            if (attribute.match(signer)) {
                ICertificateValidator validator = ValidationContext.get().getCertificateValidator();
                state = validator.validate(attribute, parameters);
            } else {
                IValidationMessage msg = ValidationMessage.createError(Msg.getString("CommonPKISignatureEntryValidator.UnmatchedAttributeCertificate", new Object[0]));
                state = VSCertificate.createInvalid((IX509Certificate)attribute, msg);
            }
            ((CommonValidationState)((Object)state)).setSeverity(2);
            attributeStates.add(state);
        }
        return attributeStates;
    }

    protected void validateCertificates(ISignatureEntry signatureEntry, VSSignatureEntry entryState, IValidationParameters parameters) {
        List evdCertificates;
        IAttributeMap signedAttributes;
        List<IX509AttributeCertificate> attributes;
        List<IX509PublicKeyCertificate> additional;
        IX509PublicKeyCertificate signer;
        try {
            signer = signatureEntry.getSignerCertificate();
            additional = signatureEntry.getAdditionalCertificates();
            attributes = CommonPKISignatureEntryValidator.getAttributeCertificates(signatureEntry);
            signedAttributes = signatureEntry.getSignedAttributes();
        }
        catch (IOException e) {
            IValidationMessage msg = CommonValidationMessages.ERROR_CERTIFICATE(e);
            entryState.setCertificateState(VSCertificate.createInvalid(msg));
            return;
        }
        catch (CertificateException e) {
            IValidationMessage msg = CommonValidationMessages.ERROR_CERTIFICATE(e);
            entryState.setCertificateState(VSCertificate.createInvalid(msg));
            return;
        }
        if (signer == null) {
            IValidationMessage msg = CommonValidationMessages.ERROR_CERTIFICATE_NOT_AVAILABLE();
            entryState.setCertificateState(VSCertificate.createInvalid(msg));
            return;
        }
        Date date = parameters.basicGetDateToTest();
        boolean confirmedDate = parameters.isConfirmedDate();
        if (date == null) {
            date = entryState.getCreationDate();
            if (date != null && date.after(DateEnvironment.get().now())) {
                entryState.addMessage(ValidationMessage.createWarning(Msg.getString("CommonPKISignatureEntryValidator.WarningSignatureDateInFuture", new Object[0])));
            }
            if ("timestamp".equals(entryState.getCreationDateSource())) {
                confirmedDate = true;
            }
        }
        ValidationParameters certificateParameters = ValidationParameters.copy(parameters);
        CompositeCertificateProvider additionalCertificates = new CompositeCertificateProvider();
        additionalCertificates.registerCertificateProvider(new CollectionCertificateProvider(additional));
        IExtendedValidationData validationData = parameters.getExtendedValidationData();
        if (validationData != null && !(evdCertificates = validationData.getCertificates().collect(Collectors.toList())).isEmpty()) {
            additionalCertificates.registerCertificateProvider(new CollectionCertificateProvider(evdCertificates));
        }
        additionalCertificates.registerCertificateProvider(certificateParameters.getAdditionalCerts());
        certificateParameters.setAdditionalCerts(additionalCertificates);
        certificateParameters.setDateToTest(date, confirmedDate);
        IVSCertificate signerCertState = this.validateSignerCertificate(signer, parameters.getKeyPurpose(), certificateParameters);
        signerCertState = this.checkSignerCertificateIntegrity(signer, signedAttributes, signerCertState);
        entryState.setCertificateState(signerCertState);
        List<IVSCertificate> attributeStates = this.validateAttributeCertificates(attributes, signer, certificateParameters);
        entryState.setAttributeCertificateStates(attributeStates);
    }

    private IVSCertificate validateSignerCertificate(IX509PublicKeyCertificate certificate, EnumKeyPurpose keyPurpose, IValidationParameters parameters) {
        ValidationParameters localParameters = ValidationParameters.copy(parameters);
        localParameters.setKeyPurpose(keyPurpose);
        ICertificateValidator validator = ValidationContext.get().getCertificateValidator();
        IVSCertificate state = validator.validate(certificate, localParameters);
        return state;
    }

    protected IVSTimestamp validateTimestamp(ITimestampToken timestamp, byte[] timestampedData, IValidationParameters parameters) {
        IDigest digest = null;
        if (timestampedData != null) {
            String algorithmName = null;
            try {
                ITimestampInfo timestampInfo = timestamp.getTimestampInfo();
                algorithmName = timestampInfo.getMessageImprintAlgorithmOID();
                String jcaName = SignatureAlgorithm.getHashAlgorithmName(algorithmName);
                if (jcaName == null) {
                    throw new NoSuchAlgorithmException(algorithmName);
                }
                IDigester digester = DigestTools.createDigester((String)jcaName);
                digest = digester.digest(timestampedData);
            }
            catch (IOException e) {
                VSTimestamp result = new VSTimestamp(timestamp);
                result.invalidate(CommonValidationMessages.ERROR_IO(e));
                return result;
            }
            catch (NoSuchAlgorithmException e) {
                VSTimestamp result = new VSTimestamp(timestamp);
                result.invalidate(CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN(e, algorithmName));
                return result;
            }
        }
        IVSTimestamp state = ValidationContext.get().getTimestampValidator().validate(timestamp, digest, parameters);
        VSTimestamp myState = CommonValidationState.castOrCopy(state, VSTimestamp.class);
        myState.setSeverity(2);
        return state;
    }

    protected void validateTimestamps(ISignatureEntry entry, VSSignatureEntry entryState, IValidationParameters parameters) {
        ISignatureTimestampAttribute timestampAttribute;
        IAttributeMap attributeSet = entry.getUnsignedAttributes();
        try {
            timestampAttribute = (ISignatureTimestampAttribute)attributeSet.get("1.2.840.113549.1.9.16.2.14");
            if (timestampAttribute == null) {
                return;
            }
        }
        catch (IOException e) {
            VSTimestamp timestampState = new VSTimestamp(null, 3);
            timestampState.addMessage(ValidationMessage.createError(e.getLocalizedMessage()));
            entryState.addTimestampState(timestampState);
            return;
        }
        ITimestampToken[] timestamps = timestampAttribute.getTimestamps();
        byte[] bytes = entry.getTimestampInput();
        for (int i = 0; i < timestamps.length; ++i) {
            ITimestampToken timestamp = timestamps[i];
            IVSTimestamp timestampState = this.validateTimestamp(timestamp, bytes, parameters);
            entryState.addTimestampState(timestampState);
        }
    }
}

