/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.IOCSPService;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.X509SignatureValidator;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.OCSPClient;
import de.intarsys.security.app.validation.commonpki.OCSPException;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.TrustBaseTools;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.StandardCertificateProviderTools;
import de.intarsys.security.certificate.provider.standard.TrustedQESCertificateProvider;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.IOCSPSingleResult;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSOCSP;
import de.intarsys.security.standard.validation.VSOCSPRequest;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.standard.validation.commonpki.OCSPDepth;
import de.intarsys.security.standard.validation.ocsp.IOCSPCache;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.Origin;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPKIOCSPService
implements IOCSPService {
    private static final Logger Log = LoggerFactory.getLogger(CommonPKIOCSPService.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final String PROVIDER = "BC";
    private static Date confirmedTimeRequiredSince = new GregorianCalendar(2017, 0, 1).getTime();
    private IOCSPCache cache;
    private IX509PublicKeyCertificate[] certsForSigning;
    private String defaultURL;
    private OCSPDepth ocspDepth;
    private PrivateKey privateKey;
    private String signatureAlgorithm;
    private boolean signRequest = false;
    private boolean verifyResult = true;
    private boolean warnOnNoURL = true;
    private final OCSPClient client = new OCSPClient();
    private long defaultAcceptPeriod = 10000L;

    protected void checkCertificate(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath, VSOCSPRequest state, IValidationParameters parameters) {
        int certState = result.getStatus();
        switch (certState) {
            case 0: {
                Log.debug("certificate status: unknown");
                this.checkCertificateUnknown(result, response, certificatePath, state, parameters);
                break;
            }
            case 1: {
                Log.debug("certificate status: valid");
                this.checkCertificateGood(result, response, certificatePath, state, parameters);
                break;
            }
            case 2: {
                Log.debug("certificate status: revoked");
                this.checkCertificateRevoked(result, response, certificatePath, state, parameters);
                break;
            }
            default: {
                Log.debug("certificate status: <unknown state>");
                this.checkCertificateUnknown(result, response, certificatePath, state, parameters);
            }
        }
    }

    protected void checkCertificateGood(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath, VSOCSPRequest state, IValidationParameters parameters) {
        state.setRevocationState(Msg.getString("CommonPKIOCSPService.RevocationStateGood", new Object[0]));
        state.increaseState(0);
        boolean hasPositiveStatement = false;
        try {
            CertHash certHash = this.getCertHash(result);
            if (certHash == null && (certHash = this.getCertHash(response)) != null) {
                state.addMessage(ValidationMessage.createWarning(Msg.getString("CommonPKIOCSPService.PositiveStatementInWrongPlace", new Object[0])));
            }
            if (certHash != null) {
                hasPositiveStatement = this.isCertHash(result.getCertificate(), certHash);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            state.addMessage(ValidationMessage.createError(e.getLocalizedMessage(), (Throwable)e));
        }
        if (hasPositiveStatement) {
            state.addMessage(ValidationMessage.createInfo(Msg.getString("CommonPKIOCSPService.PositiveStatement", new Object[0])));
            state.setPositiveStatement(true);
        } else {
            this.responseNoPositiveStatement(result, response, certificatePath, state, parameters);
            Date certExpiryDate = result.getCertificate().getNotAfter();
            Date cutoff = this.getCutoff(result, response, certificatePath);
            state.setArchiveCutoff(cutoff);
            if (cutoff.after(certExpiryDate)) {
                this.responseAfterCutoff(result, response, certificatePath, state, parameters);
            }
        }
    }

    protected void checkCertificateRevoked(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath, VSOCSPRequest state, IValidationParameters parameters) {
        Date revocationDate = result.getRevocationTime();
        Date dateToTest = this.getDateToTest(parameters);
        if (dateToTest.after(revocationDate)) {
            state.setRevocationState(Msg.getString("CommonPKIOCSPService.RevocationStateRevoked", new Object[0]));
            state.setRevocationDate(revocationDate);
            int reason = result.getRevocationReason();
            state.setRevocationReason(reason);
            state.increaseState(3);
            state.addMessage(ValidationMessage.createError(Msg.getString("CommonPKIOCSPService.MessageCertificateRevoked", new Object[0])));
        } else {
            this.checkCertificateGood(result, response, certificatePath, state, parameters);
        }
    }

    protected boolean checkCertificateStatus(VSOCSPRequest state, IOCSPResponse response, IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters parameters) {
        state.setResult(Msg.getString("CommonPKIOCSPService.MessageSuccessful", new Object[0]));
        IOCSPSingleResult singleResult = response.getSingleResult(certificate, certificatePath.getIssuerCertificate(certificate));
        Date nextUpdate = singleResult.getNextUpdate();
        if (nextUpdate == null && this.getDefaultAcceptPeriod() > -1L) {
            nextUpdate = new Date(response.getProducedAt().getTime() + this.getDefaultAcceptPeriod());
        }
        Date referenceDate = this.getDateToTest(parameters);
        if (nextUpdate != null && nextUpdate.before(referenceDate)) {
            Log.debug("ocsp response too old");
            state.invalidate(ValidationMessage.createError(Msg.getString("CommonPKIOCSPService.ResponseTooOld", new Object[0])));
            return false;
        }
        this.checkCertificate(singleResult, response, certificatePath, state, parameters);
        return true;
    }

    protected void checkCertificateUnknown(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath, VSOCSPRequest state, IValidationParameters parameters) {
        state.setRevocationState(Msg.getString("CommonPKIOCSPService.RevocationStateUnknown", new Object[0]));
        state.increaseState(2);
    }

    protected VSOCSP checkOcspByURLs(List<String> urls, IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters parameters) {
        OCSPReq req;
        VSOCSP state = new VSOCSP();
        if (urls.size() == 0) {
            String msgTxt = Msg.getString("CommonPKIOCSPService.WarningNoOCSPURLFound", new Object[0]);
            if (this.isWarnOnNoURL()) {
                state.addMessage(ValidationMessage.createWarning(msgTxt));
            } else {
                state.addMessage(ValidationMessage.createInfo(msgTxt));
            }
            return state;
        }
        IX509PublicKeyCertificate issuerCertificate = null;
        if (certificatePath != null) {
            issuerCertificate = certificatePath.getIssuerCertificate(certificate);
        }
        if (issuerCertificate == null) {
            Log.debug("issuer certificate not available for OCSP request generation");
            state.addMessage(ValidationMessage.createError(Msg.getString("CommonPKIOCSPService.IssuerCertificateNotAvailable", new Object[0])));
            return state;
        }
        OCSPReq signedReq = null;
        try {
            req = this.createRequest(certificate, issuerCertificate, false);
            if (this.isSignRequest()) {
                signedReq = this.createRequest(certificate, issuerCertificate, true);
            }
        }
        catch (NoSuchProviderException e) {
            Log.debug(e.getMessage(), (Throwable)e);
            state.addMessage(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return state;
        }
        catch (OCSPException e) {
            Log.debug(e.getMessage(), (Throwable)e);
            state.addMessage(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return state;
        }
        for (String url : urls) {
            VSOCSPRequest requestState = new VSOCSPRequest(0);
            requestState.setOrigin(Origin.url(url));
            int status = 0;
            BasicOCSPResp basicResp = null;
            if (this.getCache() != null) {
                basicResp = this.getCache().lookupResponse(certificate, issuerCertificate, url, this.getDateToTest(parameters));
            }
            if (basicResp == null) {
                OCSPResp response = this.getResponse(req, url, requestState);
                if (response != null && response.getStatus() == 5) {
                    Log.debug("signature required, resending signed request");
                    response = this.getResponse(signedReq, url, requestState);
                }
                if (this.checkResponseStatus(requestState, response)) {
                    try {
                        basicResp = (BasicOCSPResp)response.getResponseObject();
                    }
                    catch (org.bouncycastle.cert.ocsp.OCSPException e) {
                        requestState.invalidate(CommonValidationMessages.ERROR_CERTIFICATE((Exception)((Object)e)));
                    }
                    status = response.getStatus();
                    if (this.getCache() != null && status == 0) {
                        this.getCache().cacheResponse(certificate, issuerCertificate, url, basicResp);
                    }
                }
            }
            boolean propagateState = false;
            if (basicResp == null) {
                if (status == 6) {
                    propagateState = true;
                }
            } else {
                OCSPResponse ocspResponse = new OCSPResponse(basicResp);
                requestState.setResponse(ocspResponse);
                if (ocspResponse.hasStatusOfCertificate(certificate, issuerCertificate)) {
                    propagateState = requestState.isValid();
                    if (this.isVerifyResult()) {
                        this.validateResponse(certificate, certificatePath, ocspResponse, requestState, parameters);
                        propagateState = propagateState && requestState.isValid();
                    }
                    propagateState = propagateState && this.checkCertificateStatus(requestState, ocspResponse, certificate, certificatePath, parameters);
                } else if (status != 0) {
                    this.checkCertificateStatus(requestState, ocspResponse, certificate, certificatePath, parameters);
                }
            }
            if (!propagateState) {
                requestState.setSeverity(2);
            }
            state.addRequestState(requestState);
        }
        return state;
    }

    protected VSOCSP checkOcspByValidationData(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters parameters) {
        VSOCSP state = new VSOCSP();
        IExtendedValidationData validationData = parameters.getExtendedValidationData();
        if (validationData == null) {
            return state;
        }
        IX509PublicKeyCertificate issuerCertificate = certificatePath == null ? null : certificatePath.getIssuerCertificate(certificate);
        validationData.getOCSPResponses().forEach(ocsp -> {
            if (ocsp.getSingleResult(certificate, issuerCertificate) != null) {
                VSOCSPRequest requestState = new VSOCSPRequest((IOCSPResponse)ocsp, 0);
                requestState.setOrigin(Origin.embedded());
                boolean propagateState = true;
                if (this.isVerifyResult()) {
                    this.validateResponse(certificate, certificatePath, (IOCSPResponse)ocsp, requestState, parameters);
                    if (!requestState.isValid()) {
                        propagateState = false;
                    }
                }
                boolean bl = propagateState = propagateState && this.checkCertificateStatus(requestState, (IOCSPResponse)ocsp, certificate, certificatePath, parameters);
                if (!propagateState) {
                    requestState.setSeverity(2);
                }
                state.addRequestState(requestState);
            }
        });
        return state;
    }

    protected boolean checkResponseStatus(VSOCSPRequest state, OCSPResp response) {
        if (response == null) {
            Log.warn("response status unknown");
            state.increaseState(2);
            return false;
        }
        int status = response.getStatus();
        switch (status) {
            case 0: {
                Log.debug("response status: " + status + " (successful)");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageSuccessful", new Object[0]));
                return true;
            }
            case 1: {
                Log.warn("response status: " + status + " (malformed request)");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageMalformedRequest", new Object[0]));
                state.increaseState(2);
                break;
            }
            case 2: {
                Log.warn("response status: " + status + " (internal error)");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageInternalError", new Object[0]));
                state.increaseState(2);
                break;
            }
            case 3: {
                Log.warn("response status: " + status + " (try later)");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageTryLater", new Object[0]));
                state.increaseState(2);
                break;
            }
            case 5: {
                Log.warn("response status: " + status + " (sig required)");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageSignatureRequired", new Object[0]));
                state.increaseState(2);
                break;
            }
            case 6: {
                Log.warn("response status: " + status + " (unauthorized)");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageUnauthorized", new Object[0]));
                state.addMessage(ValidationMessage.createWarning(Msg.getString("CommonPKIOCSPService.NoReliableInformation", new Object[0])));
                state.increaseState(2);
                break;
            }
            default: {
                Log.warn("response status unknown");
                state.setResult(Msg.getString("CommonPKIOCSPService.MessageUnknown", new Object[0]));
                state.increaseState(2);
            }
        }
        return false;
    }

    protected CertificateID createCertificateID(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate) throws NoSuchProviderException, OCSPException {
        String hashAlgorithm = CertificateID.HASH_SHA1.getAlgorithm().getId();
        String provider = PROVIDER;
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm, provider);
            AlgorithmIdentifier hashAlg = new AlgorithmIdentifier(new ASN1ObjectIdentifier(hashAlgorithm), (ASN1Encodable)DERNull.INSTANCE);
            digest.update(issuerCertificate.getSubjectX500Principal().getEncoded());
            DEROctetString issuerNameHash = new DEROctetString(digest.digest());
            PublicKey issuerKey = issuerCertificate.getPublicKey();
            byte[] issuerKeyEncoded = OCSPResponse.getDigesterData(issuerKey);
            digest.update(issuerKeyEncoded);
            DEROctetString issuerKeyHash = new DEROctetString(digest.digest());
            ASN1Integer serialNumber = new ASN1Integer(certificate.getSerialNumber());
            CertID certId = new CertID(hashAlg, (ASN1OctetString)issuerNameHash, (ASN1OctetString)issuerKeyHash, serialNumber);
            return new CertificateID(certId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
        catch (IOException e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }

    protected ContentSigner createContentSigner() throws OperatorCreationException {
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder(this.signatureAlgorithm);
        builder.setProvider(PROVIDER);
        return builder.build(this.privateKey);
    }

    protected OCSPReq createRequest(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate, boolean sign) throws NoSuchProviderException, OCSPException {
        OCSPReqBuilder reqGen = new OCSPReqBuilder();
        CertificateID certificateID = this.createCertificateID(certificate, issuerCertificate);
        reqGen.addRequest(certificateID);
        try {
            if (sign) {
                X500Name requestorName = X500Name.getInstance((Object)this.certsForSigning[0].getSubjectX500Principal().getEncoded());
                reqGen.setRequestorName(requestorName);
                ContentSigner contentSigner = this.createContentSigner();
                return reqGen.build(contentSigner, CertificateTools.toCertificateHolders(this.certsForSigning));
            }
            return reqGen.build();
        }
        catch (IOException | IllegalArgumentException | CertificateException | org.bouncycastle.cert.ocsp.OCSPException | OperatorCreationException e) {
            throw new OCSPException("", e);
        }
    }

    public IOCSPCache getCache() {
        return this.cache;
    }

    protected CertHash getCertHash(X509Extension extensionSupport) throws IOException {
        ASN1Primitive derCertHash = CertificateTools.getExtensionValue(extensionSupport, "1.3.36.8.3.13");
        return CertHash.getInstance((Object)derCertHash);
    }

    public int getConnectTimeout() {
        return this.client.getConnectTimeout();
    }

    protected Date getCutoff(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath) {
        Date cutoff = result.getArchiveCutoff();
        if (cutoff == null) {
            cutoff = response.getArchiveCutoff();
        }
        if (cutoff != null) {
            return cutoff;
        }
        int retentionPeriod = this.getRetentionPeriod(certificatePath);
        GregorianCalendar producedAt = new GregorianCalendar();
        producedAt.setTime(response.getProducedAt());
        producedAt.add(1, -retentionPeriod);
        return producedAt.getTime();
    }

    protected Date getDateToTest(IValidationParameters parameters) {
        Date dateToTest = parameters.getDateToTest();
        if (parameters.isConfirmedDate() || dateToTest.before(confirmedTimeRequiredSince)) {
            return dateToTest;
        }
        return DateEnvironment.get().now();
    }

    public long getDefaultAcceptPeriod() {
        return this.defaultAcceptPeriod;
    }

    public String getDefaultURL() {
        return this.defaultURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getErrorMessage(HttpURLConnection con) {
        InputStream in;
        Object responseMsg = null;
        try {
            responseMsg = con.getResponseMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseMsg == null) {
            responseMsg = "";
        }
        if ((in = con.getErrorStream()) == null) {
            return responseMsg;
        }
        StringWriter w = new StringWriter();
        try {
            InputStreamReader r = new InputStreamReader(in);
            int i = r.read();
            while (i != -1) {
                w.write(i);
                i = r.read();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            StreamTools.close((Closeable)in);
        }
        responseMsg = (String)responseMsg + "(" + w.toString() + ")";
        return responseMsg;
    }

    public OCSPDepth getOcspDepth() {
        return this.ocspDepth;
    }

    public int getReadTimeout() {
        return this.client.getReadTimeout();
    }

    private OCSPResp getResponse(OCSPReq request, String url, VSOCSPRequest state) {
        try {
            OCSPResp responseData = this.client.sendRequest(request, url);
            if (responseData == null) {
                state.increaseState(2);
                return null;
            }
            return responseData;
        }
        catch (OCSPException e) {
            state.addMessage(ValidationMessage.createWarning(e.getMessage()));
            state.increaseState(2);
            return null;
        }
    }

    protected int getRetentionPeriod(IX509CertificatePath path) {
        ITrustBase trustBase = this.getTrustBase(path);
        String type = null;
        if (trustBase != null) {
            type = trustBase.getType();
        }
        if ("DE/accredited".equals(type)) {
            return 30;
        }
        if ("DE/accredited".equals(type)) {
            return 5;
        }
        return 0;
    }

    public SSLContext getSslContext() {
        return this.client.getSslContext();
    }

    protected ITrustBase getTrustBase(IX509CertificatePath path) {
        IX509Certificate qcRoot = null;
        for (IX509Certificate currentCertificate : IterableTools.in((Iterator)new ReverseListIterator(path.getPath()))) {
            IX509Certificate trustedEntry = StandardCertificateProviderTools.lookupStoredCertificate(TrustedQESCertificateProvider.get(), currentCertificate);
            if (trustedEntry == null) continue;
            qcRoot = trustedEntry;
        }
        if (qcRoot == null) {
            return null;
        }
        return TrustBaseTools.getTrustBase(qcRoot);
    }

    public boolean hasPositiveStatement(IOCSPSingleResult singleResult, IOCSPResponse response) {
        try {
            CertHash certHash = this.getCertHash(singleResult);
            if (certHash == null && (certHash = this.getCertHash(response)) == null) {
                return false;
            }
            String algOID = certHash.getHashAlgorithm().getAlgorithm().getId();
            DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(algOID);
            IDigest referenceDigest = DigestTools.createDigest((String)algorithm.getName(), (byte[])certHash.getCertificateHash());
            IDigester digester = DigestTools.createDigester((String)algorithm.getName());
            IDigest certDigest = digester.digest(singleResult.getCertificate().getEncoded());
            return referenceDigest.equals(certDigest);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected boolean isCertHash(IX509Certificate certificate, CertHash certHash) throws GeneralSecurityException {
        String algOID = certHash.getHashAlgorithm().getAlgorithm().getId();
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(algOID);
        if (algorithm == null) {
            throw new NoSuchAlgorithmException(algOID);
        }
        IDigest referenceDigest = DigestTools.createDigest((String)algorithm.getName(), (byte[])certHash.getCertificateHash());
        IDigester digester = DigestTools.createDigester((String)algorithm.getName());
        IDigest certDigest = digester.digest(certificate.getEncoded());
        return referenceDigest.equals(certDigest);
    }

    public boolean isSignRequest() {
        return this.signRequest;
    }

    public boolean isVerifyResult() {
        return this.verifyResult;
    }

    public boolean isWarnOnNoURL() {
        return this.warnOnNoURL;
    }

    protected void responseAfterCutoff(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath, VSOCSPRequest state, IValidationParameters parameters) {
        state.addMessage(ValidationMessage.createWarning(Msg.getString("CommonPKIOCSPService.NoReliableInformation", new Object[0])));
    }

    protected void responseNoPositiveStatement(IOCSPSingleResult result, IOCSPResponse response, IX509CertificatePath certificatePath, VSOCSPRequest state, IValidationParameters parameters) {
        state.addMessage(ValidationMessage.createInfo(Msg.getString("CommonPKIOCSPService.NoPositiveStatement", new Object[0])));
    }

    public void setCache(IOCSPCache cache) {
        this.cache = cache;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.client.setConnectTimeout(connectTimeout);
    }

    public void setDefaultAcceptPeriod(long defaultOcspResponseAcceptability) {
        this.defaultAcceptPeriod = defaultOcspResponseAcceptability;
    }

    public void setDefaultURL(String defaultURL) {
        this.defaultURL = defaultURL;
    }

    public void setOcspDepth(OCSPDepth ocspDepth) {
        this.ocspDepth = ocspDepth;
    }

    public void setReadTimeout(int readTimeout) {
        this.client.setReadTimeout(readTimeout);
    }

    public void setRequestSignatureData(String signatureAlgorithm, PrivateKey privateKey, IX509PublicKeyCertificate[] certs) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.privateKey = privateKey;
        this.certsForSigning = certs;
        this.signRequest = true;
    }

    public void setSslContext(SSLContext sslContext) {
        this.client.setSslContext(sslContext);
    }

    public void setVerifyResult(boolean verify) {
        this.verifyResult = verify;
    }

    public void setWarnOnNoURL(boolean warnOnNoURL) {
        this.warnOnNoURL = warnOnNoURL;
    }

    @Override
    public IVSOCSP validateCertificate(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
        if (this.getOcspDepth() == OCSPDepth.EE_ONLY || this.getOcspDepth() == OCSPDepth.EE_CHAIN) {
            if (params.getDepth() > 1) {
                return new VSOCSP(-1);
            }
            if (this.getOcspDepth() == OCSPDepth.EE_ONLY) {
                try {
                    if (!CertificateTools.isEndUserCertificate(certificate)) {
                        return new VSOCSP(-1);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            VSOCSP result = this.checkOcspByValidationData(certificate, certificatePath, params);
            if (!result.isUndefined()) {
                return result;
            }
            List localRequestStates = result.getRequestStates();
            List<String> urls = CertificateTools.getOcspURLs(certificate);
            if (urls == null) {
                urls = new ArrayList<String>();
            }
            ArrayList<String> urlsToCheck = new ArrayList<String>(urls);
            if (this.getDefaultURL() != null) {
                urlsToCheck.add(this.getDefaultURL());
            }
            if ((result = this.checkOcspByURLs(urlsToCheck, certificate, certificatePath, params)).isUndefined()) {
                result.increaseState(2);
                result.addMessage(ValidationMessage.createInfo(Msg.getString("CommonPKIOCSPService.ErrorNoValidOCSPResponse", new Object[0])));
            }
            if (localRequestStates != null) {
                for (IVSOCSPRequest localRequestState : localRequestStates) {
                    result.addRequestState(localRequestState);
                }
            }
            return result;
        }
        catch (IOException e) {
            VSOCSP state = new VSOCSP(2);
            state.addMessage(ValidationMessage.createError(e.getLocalizedMessage(), (Throwable)e));
            return state;
        }
    }

    protected void validateResponse(IX509Certificate certificate, IX509CertificatePath certificatePath, IOCSPResponse ocspResponse, VSOCSPRequest state, IValidationParameters parameters) {
        if (ocspResponse.getSignature() == null || ocspResponse.getSignature().length == 0) {
            Log.debug("ocsp response signature missing");
            state.invalidate(ValidationMessage.createError(Msg.getString("CommonPKIOCSPService.ResponseSignatureMissing", new Object[0])));
            return;
        }
        List<IX509PublicKeyCertificate> ocspCertificates = null;
        try {
            IX509PublicKeyCertificate[] ocspCertificateArray = ocspResponse.getCertificates();
            if (ocspCertificateArray != null && ocspCertificateArray.length > 0) {
                ocspCertificates = Arrays.asList(ocspCertificateArray);
            }
        }
        catch (CertificateException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            state.invalidate(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return;
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            state.invalidate(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return;
        }
        if (ocspCertificates == null) {
            ocspCertificates = new ArrayList<IX509PublicKeyCertificate>();
            IX509PublicKeyCertificate issuerCert = certificatePath.getIssuerCertificate(certificate);
            if (issuerCert != null) {
                ocspCertificates.add(issuerCert);
            }
            ocspCertificates.addAll(parameters.getExtendedValidationData().getCertificates().toList());
        }
        if (ocspCertificates.isEmpty()) {
            Log.debug("ocsp response certificate missing");
            state.invalidate(ValidationMessage.createError(Msg.getString("CommonPKIOCSPService.ResponseCertificatesMissing", new Object[0])));
            return;
        }
        X509SignatureValidator<BasicOCSPResp> sigValidator = X509SignatureValidator.createOCSPInstance();
        IX509PublicKeyCertificate signerCertificate = null;
        IVSSignature sigState = null;
        for (IX509PublicKeyCertificate currentCert : ocspCertificates) {
            BasicOCSPResp basicResp = (BasicOCSPResp)AdapterTools.getAdapter((Object)ocspResponse, BasicOCSPResp.class, null);
            IVSSignature currentSigState = sigValidator.validate(basicResp, currentCert);
            if (!currentSigState.isValid()) continue;
            signerCertificate = currentCert;
            sigState = currentSigState;
            break;
        }
        if (signerCertificate == null) {
            Log.debug("ocsp response signer certificate missing");
            state.invalidate(ValidationMessage.createError(Msg.getString("CommonPKIOCSPService.ResponseCertificatesMissing", new Object[0])));
            return;
        }
        if (sigState != null) {
            state.setSignatureState(sigState);
        }
        ArrayList<IX509PublicKeyCertificate> additionalCertificates = new ArrayList<IX509PublicKeyCertificate>(ocspCertificates);
        additionalCertificates.remove(signerCertificate);
        Date producedAt = ocspResponse.getProducedAt();
        ValidationParameters myParams = ValidationParameters.copy(parameters);
        myParams.setKeyPurpose(EnumKeyPurpose.OCSP_SIGNING);
        myParams.setDateToTest(producedAt, true);
        ICertificateProvider trusted = myParams.getTrustedCerts();
        CompositeCertificateProvider newTrusted = new CompositeCertificateProvider();
        newTrusted.registerCertificateProvider(new CollectionCertificateProvider(certificatePath.getPath()));
        newTrusted.registerCertificateProvider(trusted);
        myParams.setTrustedCerts(newTrusted);
        CompositeCertificateProvider newAdditional = new CompositeCertificateProvider();
        newAdditional.registerCertificateProvider(new CollectionCertificateProvider(additionalCertificates));
        newAdditional.registerCertificateProvider(myParams.getAdditionalCerts());
        myParams.setAdditionalCerts(newAdditional);
        IVSCertificate certificateState = ValidationContext.get().getCertificateValidator().validate(signerCertificate, myParams);
        if (certificateState != null) {
            state.setCertificateState(certificateState);
        }
        HashSet<String> criticalExtensions = new HashSet<String>();
        if (ocspResponse.getCriticalExtensionOIDs() != null) {
            criticalExtensions.addAll(ocspResponse.getCriticalExtensionOIDs());
        }
        criticalExtensions.remove("1.3.6.1.5.5.7.48.1.6");
        criticalExtensions.remove("1.3.36.8.3.13");
        if (!criticalExtensions.isEmpty()) {
            for (String extensionId : criticalExtensions) {
                Log.debug("ocsp response contains unkown critical extensions");
                state.invalidate(CommonValidationMessages.ERROR_UNPROCESSED_CRITICAL_EXTENSION(extensionId));
            }
        }
    }
}

