/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.common.EnumForceValidationLevel;
import de.intarsys.security.app.validation.common.IStateCachingStrategy;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.IArgs;

public class StateCachingStrategy {
    private static final IStateCachingStrategy NOCACHE = new IStateCachingStrategy(){

        @Override
        public void cacheState(Object validationTarget, IValidationState state) {
        }

        @Override
        public IValidationState getCachedState(Object validationTarget) {
            return null;
        }
    };

    public static IStateCachingStrategy basic(EnumForceValidationLevel forceLevel) {
        return new BasicCachingStrategy(forceLevel);
    }

    public static IStateCachingStrategy noCache() {
        return NOCACHE;
    }

    private static class BasicCachingStrategy
    implements IStateCachingStrategy {
        private EnumForceValidationLevel forceLevel;

        public BasicCachingStrategy(EnumForceValidationLevel forceLevel) {
            this.forceLevel = forceLevel;
        }

        @Override
        public void cacheState(Object validationTarget, IValidationState state) {
            if (validationTarget instanceof ISignatureContainer) {
                VSSignatureContainer.setSignatureContainerState((ISignatureContainer)validationTarget, (IVSSignatureContainer)state);
            } else if (validationTarget instanceof IAttributeSupport) {
                ((IAttributeSupport)validationTarget).setAttribute((Object)StateKey.create(), (Object)state);
            }
        }

        @Override
        public IValidationState getCachedState(Object validationTarget) {
            if (validationTarget instanceof ISignatureContainer) {
                IVSSignatureContainer containerState;
                if (this.forceLevel == EnumForceValidationLevel.NONE && (containerState = VSSignatureContainer.getSignatureContainerState((ISignatureContainer)validationTarget)) != null && !containerState.isUndefined()) {
                    return containerState;
                }
                return null;
            }
            if (validationTarget instanceof ISignatureEntry) {
                if (this.forceLevel == EnumForceValidationLevel.SIGNATURE_ONLY) {
                    return this.getReusableState((IAttributeSupport)validationTarget);
                }
                return null;
            }
            if (validationTarget instanceof IAttributeSupport) {
                return this.getReusableState((IAttributeSupport)validationTarget);
            }
            return null;
        }

        protected IValidationState getReusableState(IAttributeSupport obj) {
            StateKey key = StateKey.create();
            IValidationState previousState = (IValidationState)obj.getAttribute((Object)key);
            if (previousState == null || previousState.isUndefined()) {
                return null;
            }
            return previousState;
        }
    }

    private static class StateKey {
        private Class contextClass;
        private IArgs args;

        public static StateKey create() {
            IValidationContext context = ValidationContext.getCurrent();
            return new StateKey(context.getClass(), context.getArgs());
        }

        public StateKey(Class contextClass, IArgs args) {
            this.contextClass = contextClass;
            this.args = args;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StateKey)) {
                return false;
            }
            StateKey other = (StateKey)obj;
            if (this.contextClass != other.contextClass) {
                return false;
            }
            return this.args.equals(other.args);
        }

        public int hashCode() {
            return (this.contextClass.hashCode() + "@" + this.args.hashCode()).hashCode();
        }
    }
}

