/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.CachingDigestProvider;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class LocatorDigestProvider
extends CachingDigestProvider {
    private ILocator locator;

    public LocatorDigestProvider(ILocator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IDigest basicDigest(AlgorithmSpec algorithmSpec) throws NoSuchAlgorithmException, IOException {
        IDigester digester = DigestTools.createDigester((String)((Algorithm)algorithmSpec.getAlgorithm()).getCanonicalName());
        InputStream is = null;
        try {
            is = this.getLocator().getInputStream();
            IDigest iDigest = DigestTools.digest((IDigester)digester, (InputStream)is);
            return iDigest;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    public ILocator getLocator() {
        return this.locator;
    }
}

