/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import java.util.HashMap;
import java.util.Map;

public class EncryptionAlgorithm
extends Algorithm {
    private static final Map<String, EncryptionAlgorithm> algorithms = new HashMap<String, EncryptionAlgorithm>();
    public static final String NAME_EC = "EC";
    public static final String NAME_ECDSA = "ECDSA";
    public static final String NAME_RSA = "RSA";
    public static final String NAME_AES = "AES";
    public static final String NAME_UNKNOWN = "EncryptionAlgorithm.unknown";
    public static final String NAME_UNDEFINED = "EncryptionAlgorithm.undefined";
    public static final String OID_AES = "2.16.840.1.101.3.4.1";
    public static final EncryptionAlgorithm ALG_EC = new EncryptionAlgorithm("EC", "", 16, 16, null);
    public static final EncryptionAlgorithm ALG_ECDSA = new EncryptionAlgorithm("ECDSA", "", 16, 16, null);
    public static final EncryptionAlgorithm ALG_RSA = new EncryptionAlgorithm("RSA", "", 16, 16, null);
    public static final EncryptionAlgorithm ALG_AES = new EncryptionAlgorithm("AES", "2.16.840.1.101.3.4.1", 16, 16, null);
    public static final EncryptionAlgorithm ALG_UNDEFINED = new EncryptionAlgorithm("EncryptionAlgorithm.undefined", "", 16, 16, null);
    public static final EncryptionAlgorithm ALG_UNKNOWN = new EncryptionAlgorithm("EncryptionAlgorithm.unknown", "", 16, 16, null);
    private final int blockSize;
    private final int keySize;

    public static String getEncryptionAlgorithmName(String name) {
        int index = name.indexOf(47);
        if (index >= 0) {
            return name.substring(0, index);
        }
        if ("aeswrap".equalsIgnoreCase(name)) {
            return NAME_AES;
        }
        return name;
    }

    public static EncryptionAlgorithm lookupAlgorithm(String name) {
        return algorithms.get(name);
    }

    public static EncryptionAlgorithm lookupAlgorithmCanonical(String name) {
        EncryptionAlgorithm result = algorithms.get(name);
        return result == null ? null : result.getCanonical();
    }

    protected static void register(EncryptionAlgorithm algorithm) {
        algorithms.put(algorithm.getName(), algorithm);
        algorithms.putIfAbsent(algorithm.getOid(), algorithm);
    }

    protected EncryptionAlgorithm(String name, String oid, int blockSize, int keySize, EncodingAlgorithm canonical) {
        super(name, oid, canonical);
        this.blockSize = blockSize;
        this.keySize = keySize;
        EncryptionAlgorithm.register(this);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public EncryptionAlgorithm getCanonical() {
        return (EncryptionAlgorithm)super.getCanonical();
    }

    public int getKeySize() {
        return this.keySize;
    }
}

