/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.algorithm.common.WeakDigestAlgorithmValidator;
import de.intarsys.security.algorithm.common.WeakSignatureAlgorithmValidator;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationResult;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Map;

public class AlgorithmTools {
    public static IValidationResult checkForWeakHashAlgorithm(CommonPKIProfile profile, String hashAlgorithmName) {
        DigestAlgorithm target = DigestAlgorithm.lookupAlgorithmCanonical(hashAlgorithmName);
        return profile == CommonPKIProfile.QES_SigG ? new WeakDigestAlgorithmValidator().validate(target) : new ValidationResult((Object)target);
    }

    public static IValidationResult checkForWeakSignatureAlgorithm(CommonPKIProfile profile, IX509PublicKeyCertificate cert) {
        EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.lookupAlgorithmCanonical(cert.getPublicKey().getAlgorithm());
        SignatureAlgorithm target = new SignatureAlgorithm(null, null, encryptionAlgorithm, DigestAlgorithm.ALG_UNKNOWN, EncodingAlgorithm.ALG_UNKNOWN, cert.getKeyBitSize(), null);
        return profile == CommonPKIProfile.QES_SigG ? new WeakSignatureAlgorithmValidator("certificate").validate(target) : new ValidationResult((Object)target);
    }

    public static <T extends AlgorithmParameterSpec> T toAlgorithmParameterSpec(byte[] encoded, String algorithmName, Class<T> paramSpec) throws GeneralSecurityException {
        if (encoded == null) {
            return null;
        }
        AlgorithmParameters algParams = AlgorithmParameters.getInstance(algorithmName);
        try {
            algParams.init(encoded);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return algParams.getParameterSpec(paramSpec);
    }

    public static AlgorithmParameterSpec toAlgorithmParameterSpec(Object value) throws InvalidAlgorithmParameterException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)((String)value))) {
                return null;
            }
            throw new InvalidAlgorithmParameterException("algorithm not supported: " + value);
        }
        if (value instanceof AlgorithmParameterSpec) {
            return (AlgorithmParameterSpec)value;
        }
        if (value instanceof Map) {
            value = ArgTools.toArgs((Object)value);
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            InstanceSpec spec = InstanceSpec.createFromArgs(Object.class, (Object)args);
            if (PSSParameterSpec.class.getName().equals(spec.getFactory())) {
                String tmpAlgoName = ArgTools.getString((IArgs)args, (String)"args.digestAlgorithm", null);
                String hashAlgoName = DigestAlgorithm.lookupAlgorithmName(tmpAlgoName);
                int saltLength = ArgTools.getIntStrict((IArgs)args, (String)"args.saltLength", (int)0);
                int trailer = ArgTools.getIntStrict((IArgs)args, (String)"args.trailerField", (int)1);
                String mgfName = ArgTools.getString((IArgs)args, (String)"args.mgfAlgorithm", (String)"MGF1");
                return new PSSParameterSpec(hashAlgoName, mgfName, new MGF1ParameterSpec(hashAlgoName), saltLength, trailer);
            }
            throw new InvalidAlgorithmParameterException("algorithm not supported: " + spec.getFactory());
        }
        throw new InvalidAlgorithmParameterException("algorithm not supported: " + value);
    }

    public static IArgs toArgs(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            PSSParameterSpec pssSpec = (PSSParameterSpec)algorithmParameterSpec;
            Args args = Args.create();
            args.put("saltLength", (Object)pssSpec.getSaltLength());
            args.put("digestAlgorithm", (Object)DigestAlgorithm.lookupOID(pssSpec.getDigestAlgorithm()));
            args.put("trailerField", (Object)pssSpec.getTrailerField());
            args.put("mgfAlgorithm", (Object)pssSpec.getMGFAlgorithm());
            InstanceSpec spec = InstanceSpec.createFromFactory(AlgorithmParameterSpec.class, (Object)PSSParameterSpec.class.getName(), (Object)args);
            return spec.toArgs();
        }
        return null;
    }

    private AlgorithmTools() {
    }
}

