/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.xmp;

import de.intarsys.security.method.pdf.xmp.ExtensionSchemaDescriptionBuilder;
import de.intarsys.security.method.pdf.xmp.GenericXMPMetadata;
import de.intarsys.security.method.pdf.xmp.XMPPropertyDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAExtension;
import org.w3c.dom.Element;

public abstract class XMPSchemaBase
extends XMPSchema {
    private String namespaceUri;
    private String schemaDescription;
    private Collection<XMPPropertyDefinition> propertyDefinitions;

    protected XMPSchemaBase(Element element, String prefix, String namespaceUri, String schemaDescription, Collection<XMPPropertyDefinition> propertyDefinitions) {
        super(element, prefix);
        this.namespaceUri = namespaceUri;
        this.schemaDescription = schemaDescription;
        this.propertyDefinitions = new ArrayList<XMPPropertyDefinition>(propertyDefinitions);
    }

    protected XMPSchemaBase(XMPMetadata parent, String namespacePrefix, String namespaceUri, String schemaDescription, Collection<XMPPropertyDefinition> propertyDefinitions) {
        super(parent, namespacePrefix, namespaceUri);
        this.namespaceUri = namespaceUri;
        this.schemaDescription = schemaDescription;
        this.propertyDefinitions = new ArrayList<XMPPropertyDefinition>(propertyDefinitions);
    }

    public void addExtensionSchemaTo(GenericXMPMetadata xmp) throws IOException {
        XMPSchemaPDFAExtension extensions = xmp.getOrCreateSchema(XMPSchemaPDFAExtension.class);
        ExtensionSchemaDescriptionBuilder builder = new ExtensionSchemaDescriptionBuilder(extensions, this.schemaDescription, this.namespaceUri, this.prefix);
        for (XMPPropertyDefinition definition : this.propertyDefinitions) {
            builder.addProperty(definition.getName(), definition.getValueType(), definition.getCategory(), definition.getDescription());
        }
    }

    public boolean isExtensionSchemaDefinedIn(GenericXMPMetadata xmp) throws IOException {
        XMPSchemaPDFAExtension extensions = xmp.getSchema(XMPSchemaPDFAExtension.class);
        return extensions != null && extensions.getPDFASchemas().stream().anyMatch(schema -> this.namespaceUri.equals(schema.getNamespaceURI()));
    }

    protected List<String> getPropertyNames() {
        return this.propertyDefinitions.stream().map(XMPPropertyDefinition::getName).collect(Collectors.toList());
    }
}

