/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.pdf.pd.MDPPermission;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.app.validation.ITimestampEntryValidator;
import de.intarsys.security.app.validation.ITimestampValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFTimestampEntry;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.validation.MDPPErmissionPolicy;
import de.intarsys.security.method.pdf.validation.PDFChangeProvider;
import de.intarsys.security.method.pdf.validation.PDFSignatureContainerEntryValidator;
import de.intarsys.security.signature.ITimestampEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSModification;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.standard.validation.VSTimestampEntry;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IChangeProvider;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSModification;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDFTimestampEntryValidator
extends PDFSignatureContainerEntryValidator<PDFTimestampEntry, VSTimestampEntry>
implements ITimestampEntryValidator {
    private static final Logger Log = LoggerFactory.getLogger(PDFTimestampEntryValidator.class);

    @Override
    protected VSTimestampEntry createTargetState(PDFTimestampEntry entry, int state) {
        return new VSTimestampEntry((ITimestampEntry)entry, state);
    }

    @Override
    public IVSTimestampEntry validate(ITimestampEntry timestampEntry, IDigest digest, IValidationParameters parameters) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("Validating PDF timestamp...");
        }
        return (IVSTimestampEntry)super.validate((PDFTimestampEntry)timestampEntry, digest, parameters);
    }

    @Override
    protected VSTimestampEntry verify(PDFTimestampEntry entry, PDFSignatureContainer container, IRandomAccess randomAccess, Optional<PDSignatureByteRange> byteRange, IValidationParameters parameters) throws IOException {
        VSTimestampEntry entryState = this.verify(entry, new PDFSignatureContainer.DigestProvider(byteRange), parameters);
        VSTimestamp timestampState = (VSTimestamp)entryState.getTimestampState();
        VSDigest digestState = (VSDigest)timestampState.getDigestState();
        PDSignature pdSignature = entry.getPDSignature();
        MDPPermission permissions = MDPPermission.Undefined;
        boolean isDefaultPermission = false;
        if (this.isConsiderTransformations()) {
            permissions = container.getPermissions();
        }
        if (permissions == MDPPermission.Undefined) {
            isDefaultPermission = true;
            permissions = this.getDefaultPermissions();
        }
        MDPPErmissionPolicy permissionPolicy = new MDPPErmissionPolicy(permissions, !isDefaultPermission);
        VSModification modificationState = new VSModification(0);
        modificationState.setChangeProvider((IChangeProvider)new PDFChangeProvider(entry));
        modificationState.setAttribute((Object)STATEATTR_PERMISSION, (Object)permissions);
        modificationState.setAttribute((Object)STATEATTR_DEFAULTPERMISSIONS, (Object)isDefaultPermission);
        digestState.setModificationState((IVSModification)modificationState);
        int signatureLength = pdSignature.getContentBytes().length;
        this.checkByteRange(byteRange, randomAccess, digestState, modificationState, signatureLength, entry, permissionPolicy);
        timestampState.setDigestState((IVSDigest)digestState);
        if (digestState.isUndefined()) {
            timestampState.increaseState(2);
        }
        entryState.setTimestampState((IVSTimestamp)timestampState);
        entryState.setModificationState((IVSModification)modificationState);
        return entryState;
    }

    protected VSTimestampEntry verify(PDFTimestampEntry entry, PDFSignatureContainer.DigestProvider digestProvider, IValidationParameters parameters) {
        IValidationMessage message;
        VSDigest digestStateError = null;
        IDigest digest = null;
        try {
            if (entry.getHashAlgorithmSpec() != null) {
                digest = digestProvider.getDigest(entry.getHashAlgorithmSpec());
            }
        }
        catch (NoSuchAlgorithmException e) {
            message = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, (String)entry.getHashAlgorithmSpec().getAlgorithm().getCanonicalName());
            digestStateError = VSDigest.createInvalid((IValidationMessage)message);
        }
        catch (Exception e) {
            message = CommonValidationMessages.ERROR_IO((Exception)e);
            digestStateError = VSDigest.createInvalid((IValidationMessage)message);
        }
        ITimestampToken timestamp = entry.getTimestamp();
        ITimestampValidator timestampValidator = ValidationContext.get().getTimestampValidator();
        ValidationParameters localParameters = ValidationParameters.copy((IValidationParameters)parameters);
        localParameters.setExtendedValidationData(entry.getExtendedValidationData());
        IVSTimestamp timestampState = timestampValidator.validate(timestamp, digest, (IValidationParameters)localParameters);
        if (digestStateError != null) {
            ((VSTimestamp)timestampState).setDigestState((IVSDigest)digestStateError);
        }
        VSTimestampEntry entryState = new VSTimestampEntry((ITimestampEntry)entry);
        entryState.setTimestampState(timestampState);
        return entryState;
    }
}

