/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.ISignatureContainerEntryValidatorFactory;
import de.intarsys.security.app.validation.common.TimestampEntryDefaultStateFactory;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.method.pdf.validation.PDFTimestampEntryValidatorFactory;
import de.intarsys.security.signature.ITimestampEntry;
import de.intarsys.security.timestamp.ITimestampToken;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFTimestampEntry
extends PDFSignatureContainerEntry
implements ITimestampEntry {
    private static final Logger Log = LoggerFactory.getLogger(PDFTimestampEntry.class);
    private final ITimestampToken timestamp;

    protected PDFTimestampEntry(PDFSignatureContainer signatureContainer, PDSignature pdSignature, ITimestampToken timestamp) {
        super(signatureContainer, pdSignature);
        this.timestamp = timestamp;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureContainerEntryValidatorFactory.class) {
            return (T)PDFTimestampEntryValidatorFactory.get();
        }
        if (clazz == ISignatureContainerEntryDefaultStateFactory.class) {
            return (T)new TimestampEntryDefaultStateFactory();
        }
        return super.getAdapter(clazz);
    }

    public Date getCreationDate() {
        try {
            return this.getTimestamp().getTimestampInfo().getGenTime();
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public AlgorithmSpec getHashAlgorithmSpec() {
        try {
            String digestAlgorithmName = this.getTimestamp().getTimestampInfo().getMessageImprintAlgorithmName();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)digestAlgorithmName);
            if (digestAlgorithm == null) {
                return null;
            }
            return new AlgorithmSpec((Algorithm)digestAlgorithm);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ITimestampToken getTimestamp() {
        return this.timestamp;
    }
}

