/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.method.cms.attribute.encoder.AttributeCertificatesEncoder;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.RevocationInfoArchivalEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningCertificateEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningTimeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.TimestampEncoder;
import de.intarsys.security.method.cms.signature.CommonCMSSignatureContainerBuilderFactory;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Collection;
import java.util.List;

@SingletonClass
public class CMSSignatureContainerBuilderFactoryPAdESBasic
extends CommonCMSSignatureContainerBuilderFactory {
    private static final CMSSignatureContainerBuilderFactoryPAdESBasic INSTANCE = new CMSSignatureContainerBuilderFactoryPAdESBasic();

    public static CMSSignatureContainerBuilderFactoryPAdESBasic get() {
        return INSTANCE;
    }

    public String getLabel() {
        return "CMS for PAdES Basic";
    }

    protected void prepareCMSSigner(ICMSSignatureContainerBuilder builder, IArgs args) throws ObjectCreationException {
        super.prepareCMSSigner(builder, args);
        builder.setIncludeCertificates(AdESSignerTools.isIncludeCertificates((IArgs)args));
        builder.addAttributeProvider((IAttributeEncoder)new SigningTimeEncoder());
        ValidationDataOptions options = AdESSignerTools.getValidationDataOptions((IArgs)args);
        if (options.isAddValidationData()) {
            RevocationInfoArchivalEncoder attributeProvider = new RevocationInfoArchivalEncoder();
            attributeProvider.setValidationDataOptions(options);
            attributeProvider.setFailOnError(false);
            builder.addAttributeProvider((IAttributeEncoder)attributeProvider);
        }
        ITimestampCreator tsService = AdESSignerTools.createTimestampCreator((IArgs)args);
        builder.addAttributeProvider((IAttributeEncoder)new TimestampEncoder(tsService));
        List attrCerts = AdESSignerTools.getAttributeCertificates((IArgs)args);
        if (!attrCerts.isEmpty()) {
            builder.addAttributeProvider((IAttributeEncoder)new AttributeCertificatesEncoder((Collection)attrCerts));
        }
        builder.addAttributeProvider((IAttributeEncoder)new SigningCertificateEncoder());
    }
}

