/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.signature.change.DefaultChange;
import de.intarsys.pdf.signature.change.IgnorableChange;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TrailerChangeIdentifier
implements IChangeIdentifier {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected List<IDocumentChange> compareInfoDict(COSDictionary baseDict, COSDictionary newDict, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(new DefaultChange(Msg.getString("TrailerChangeIdentifier.MessageInfodictChanged", new Object[0])));
            }
        } else if (newDict == null) {
            changes.add(new DefaultChange(Msg.getString("TrailerChangeIdentifier.MessageInfodictChanged", new Object[0])));
        } else {
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                        return;
                    }
                    if (!HistoryTools.equals(baseEntry, newEntry)) {
                        if (COSInfoDict.DK_ModDate.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("TrailerChangeIdentifier.MessageModDateChanged", new Object[0])));
                        } else if (COSInfoDict.DK_CreationDate.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("TrailerChangeIdentifier.MessageCreationDateChanged", new Object[0])));
                        } else if (COSInfoDict.DK_Producer.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("TrailerChangeIdentifier.MessageProducerChanged", new Object[0])));
                        } else if (COSInfoDict.DK_Creator.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("TrailerChangeIdentifier.MessageCreatorChanged", new Object[0])));
                        } else if (COSInfoDict.DK_Title.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("TrailerChangeIdentifier.MessageTitleChanged", new Object[0])));
                        } else {
                            changes.add(new IgnorableChange(Msg.getString("TrailerChangeIdentifier.MessageInfodictChanged", new Object[0])));
                        }
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    protected List<IDocumentChange> compareInfoDict(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        return this.compareInfoDict(baseObject.dereference().asDictionary(), newObject.dereference().asDictionary(), context);
    }

    protected List<IDocumentChange> compareTrailer(COSIndirectObject baseObject, COSIndirectObject newObject, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        COSDictionary newDict = newObject.dereference().asDictionary();
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(new DefaultChange(Msg.getString("TrailerChangeIdentifier.MessageTrailerChanged", new Object[0])));
            }
        } else if (newDict == null) {
            changes.add(new DefaultChange(Msg.getString("TrailerChangeIdentifier.MessageTrailerChanged", new Object[0])));
        } else {
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (COSTrailer.DK_Info.equals((Object)key)) {
                        changes.addAll(TrailerChangeIdentifier.this.compareInfoDict(baseEntry.asDictionary(), newEntry.asDictionary(), context));
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        COSDocument baseDocument = context.getBaseDocument();
        COSTrailer trailer = baseDocument.getTrailer();
        if (trailer != null) {
            COSIndirectObject trailerRef = trailer.cosGetObject().getIndirectObject();
            if (trailerRef == baseObject) {
                return this.compareTrailer(baseObject, newObject, context);
            }
            COSIndirectObject infoRef = trailer.cosGetDict().get(COSTrailer.DK_Info).getIndirectObject();
            if (infoRef == baseObject) {
                return this.compareInfoDict(baseObject, newObject, context);
            }
        }
        return Collections.emptyList();
    }
}

