/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDStructElem;
import de.intarsys.pdf.pd.PDStructTreeRoot;
import de.intarsys.pdf.signature.change.IgnorableChange;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StructTreeChangeIdentifier
implements IChangeIdentifier {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        PDDocument doc = PDDocument.createFromCos((COSDocument)context.getBaseDocument());
        return this.identifyChangeTree(baseObject, newObject, context, doc.getCatalog().cosGetStructTreeRoot());
    }

    protected List<IDocumentChange> identifyChangeElement(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, COSDictionary element) throws IOException, COSLoadException {
        COSIndirectObject currentRef = element.getIndirectObject();
        if (currentRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSIndirectObject currentKidsRef = element.get(PDStructElem.DK_K).getIndirectObject();
        if (currentKidsRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSIndirectObject currentParentRef = element.get(PDStructElem.DK_P).getIndirectObject();
        if (currentParentRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSObject kids = element.get(PDStructElem.DK_K);
        if (kids.asDictionary() != null) {
            List<IDocumentChange> result = this.identifyChangeElement(baseObject, newObject, context, kids.asDictionary());
            if (!result.isEmpty()) {
                return result;
            }
        } else if (kids.asArray() != null) {
            COSArray kidsArray = kids.asArray();
            for (COSObject kid : kidsArray) {
                List<IDocumentChange> result;
                if (kid.asDictionary() == null || (result = this.identifyChangeElement(baseObject, newObject, context, kid.asDictionary())).isEmpty()) continue;
                return result;
            }
        }
        return Collections.emptyList();
    }

    protected List<IDocumentChange> identifyChangeTree(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, COSDictionary structTreeRoot) throws IOException, COSLoadException {
        if (structTreeRoot == null) {
            return Collections.emptyList();
        }
        COSIndirectObject currentRef = structTreeRoot.getIndirectObject();
        if (currentRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSIndirectObject currentKidsRef = structTreeRoot.get(PDStructTreeRoot.DK_K).getIndirectObject();
        if (currentKidsRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSIndirectObject currentParentTreeRef = structTreeRoot.get(PDStructTreeRoot.DK_ParentTree).getIndirectObject();
        if (currentParentTreeRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSIndirectObject currentRoleMapRef = structTreeRoot.get(PDStructTreeRoot.DK_RoleMap).getIndirectObject();
        if (currentRoleMapRef == baseObject) {
            context.setProcessed(baseObject);
            return Arrays.asList(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeChanged", new Object[]{baseObject.getKey()})));
        }
        COSObject kids = structTreeRoot.get(PDStructTreeRoot.DK_K);
        if (kids.asDictionary() != null) {
            List<IDocumentChange> result = this.identifyChangeElement(baseObject, newObject, context, kids.asDictionary());
            if (!result.isEmpty()) {
                return result;
            }
        } else if (kids.asArray() != null) {
            COSArray kidsArray = kids.asArray();
            for (COSObject kid : kidsArray) {
                List<IDocumentChange> result = this.identifyChangeElement(baseObject, newObject, context, kid.asDictionary());
                if (result.isEmpty()) continue;
                return result;
            }
        }
        return Collections.emptyList();
    }
}

