/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.app.design.AnnotationDesignerRegistry;
import de.intarsys.pdf.app.design.IAnnotationDesigner;
import de.intarsys.pdf.app.design.IAnnotationDesignerRegistry;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.signature.change.AllowedChange;
import de.intarsys.pdf.signature.change.AnnotationChange;
import de.intarsys.pdf.signature.change.DefaultChange;
import de.intarsys.pdf.signature.change.FormChangeType;
import de.intarsys.pdf.signature.change.IPDFDocumentChange;
import de.intarsys.pdf.signature.change.PageTreeChange;
import de.intarsys.pdf.signature.change.WidgetChange;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PageChangeIdentifier
implements IChangeIdentifier {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected Optional<List<IDocumentChange>> compareAnnotation(COSDocumentElement baseObject, COSDocumentElement newObject, final IChangeIdentifierContext context, final int page) throws IOException, COSLoadException {
        COSIndirectObject baseRef = null;
        if (baseObject.isReference()) {
            baseRef = (COSIndirectObject)baseObject;
        } else if (baseObject.dereference().isIndirect()) {
            baseRef = baseObject.dereference().getIndirectObject();
        }
        if (baseRef != null && context.isProcessed(baseRef)) {
            return Optional.of(Collections.emptyList());
        }
        final ArrayList<IPDFDocumentChange> changes = new ArrayList<IPDFDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        final PDAnnotation baseAnnotation = (PDAnnotation)PDAnnotation.META.createFromCos((COSObject)baseDict);
        COSDictionary newDict = newObject.dereference().asDictionary();
        PDAnnotation newAnnotation = (PDAnnotation)PDAnnotation.META.createFromCos((COSObject)newDict);
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(this.createChange(newAnnotation, page, "changed"));
            }
        } else if (newDict == null) {
            changes.add(this.createChange(baseAnnotation, page, "changed"));
        } else {
            if (baseAnnotation.isWidgetAnnotation()) {
                return Optional.empty();
            }
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) {
                    if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                        return;
                    }
                    if (!HistoryTools.equals(baseEntry, newEntry)) {
                        changes.add(PageChangeIdentifier.this.createChange(baseAnnotation, page, "changed"));
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        if (baseRef != null) {
            context.setProcessed(baseRef);
        }
        return Optional.of(changes);
    }

    protected List<IDocumentChange> compareAnnotations(COSArray baseAnnots, COSArray newAnnots, IChangeIdentifierContext context, int page) throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes;
        block11: {
            block10: {
                changes = new ArrayList<IDocumentChange>();
                if (baseAnnots != null) break block10;
                if (newAnnots == null) break block11;
                for (int i = 0; i < newAnnots.size(); ++i) {
                    PDAnnotation annot = (PDAnnotation)PDAnnotation.META.createFromCos(newAnnots.get(i));
                    changes.add(this.createChange(annot, page, "added"));
                }
                break block11;
            }
            if (newAnnots == null) {
                for (int i = 0; i < baseAnnots.size(); ++i) {
                    PDAnnotation annot = (PDAnnotation)PDAnnotation.META.createFromCos(baseAnnots.get(i));
                    changes.add(this.createChange(annot, page, "removed"));
                }
            } else {
                Set<HistoryTools.ObjectKey> allKeys = HistoryTools.collectObjectKeys(baseAnnots, newAnnots);
                Map<HistoryTools.ObjectKey, COSObject> baseMap = HistoryTools.mapObjects(baseAnnots);
                Map<HistoryTools.ObjectKey, COSObject> newMap = HistoryTools.mapObjects(newAnnots);
                for (HistoryTools.ObjectKey key : allKeys) {
                    COSObject cosBaseAnnot = baseMap.get(key);
                    PDAnnotation baseAnnot = (PDAnnotation)PDAnnotation.META.createFromCos(cosBaseAnnot);
                    COSObject cosNewAnnot = newMap.get(key);
                    PDAnnotation newAnnot = (PDAnnotation)PDAnnotation.META.createFromCos(cosNewAnnot);
                    if (baseAnnot == null) {
                        if (newAnnot == null) continue;
                        changes.add(this.createChange(newAnnot, page, "added"));
                        context.setProcessed(cosNewAnnot.getIndirectObject());
                        continue;
                    }
                    boolean processed = false;
                    if (newAnnot == null) {
                        changes.add(this.createChange(baseAnnot, page, "removed"));
                        processed = true;
                    } else {
                        Optional<List<IDocumentChange>> annotChanges = this.compareAnnotation((COSDocumentElement)cosBaseAnnot, (COSDocumentElement)cosNewAnnot, context, page);
                        if (annotChanges.isPresent()) {
                            processed = true;
                            changes.addAll((Collection<IDocumentChange>)annotChanges.get());
                            if (cosNewAnnot.isIndirect()) {
                                context.setProcessed(cosNewAnnot.getIndirectObject());
                            }
                        }
                    }
                    if (!processed || !cosBaseAnnot.isIndirect()) continue;
                    context.setProcessed(cosBaseAnnot.getIndirectObject());
                }
            }
        }
        return changes;
    }

    protected List<IDocumentChange> compareAnnotations(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, int page) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        return this.compareAnnotations(baseObject.dereference().asArray(), newObject.dereference().asArray(), context, page);
    }

    protected List<IDocumentChange> comparePage(COSIndirectObject baseObject, COSIndirectObject newObject, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        final PDPage basePage = (PDPage)PDPage.META.createFromCos((COSObject)baseDict);
        COSDictionary newDict = newObject.dereference().asDictionary();
        PDPage newPage = (PDPage)PDPage.META.createFromCos((COSObject)newDict);
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(this.createChange(newPage.getNodeIndex()));
            }
        } else if (newDict == null) {
            changes.add(this.createChange(basePage.getNodeIndex()));
        } else {
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (PDPage.DK_Annots.equals((Object)key)) {
                        changes.addAll(PageChangeIdentifier.this.compareAnnotations(baseEntry.asArray(), newEntry.asArray(), context, basePage.getNodeIndex()));
                    } else if (PDPage.DK_Tabs.equals((Object)key)) {
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.add(PageChangeIdentifier.this.createAllowedChange(basePage.getNodeIndex()));
                        }
                    } else {
                        if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                            return;
                        }
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.add(PageChangeIdentifier.this.createChange(basePage.getNodeIndex()));
                        }
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    protected List<IDocumentChange> comparePageTree(COSIndirectObject baseObject, COSIndirectObject newObject, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        COSDictionary newDict = newObject.dereference().asDictionary();
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(new PageTreeChange(Msg.getString("PageChangeIdentifier.MessagePageTreeChanged", new Object[0])));
            }
        } else if (newDict == null) {
            changes.add(new PageTreeChange(Msg.getString("PageChangeIdentifier.MessagePageTreeChanged", new Object[0])));
        } else {
            final boolean[] changed = new boolean[]{false};
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                        return;
                    }
                    if (!HistoryTools.equals(baseEntry, newEntry) && (PDObject.DK_Type.equals((Object)key) || PDPageTree.DK_Count.equals((Object)key) || PDPageTree.DK_Kids.equals((Object)key))) {
                        changed[0] = true;
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
            if (changed[0]) {
                changes.add(new PageTreeChange(Msg.getString("PageChangeIdentifier.MessagePageTreeChanged", new Object[0])));
            }
        }
        return changes;
    }

    protected IPDFDocumentChange createAllowedChange(int page) {
        return new AllowedChange(Msg.getString("PageChangeIdentifier.MessagePageChanged", new Object[]{page + 1}));
    }

    protected IPDFDocumentChange createChange(int page) {
        return new DefaultChange(Msg.getString("PageChangeIdentifier.MessagePageChanged", new Object[]{page + 1}));
    }

    protected IPDFDocumentChange createChange(PDAnnotation annotation, int page, String modification) {
        IAnnotationDesigner designer;
        if (annotation == null) {
            return new AnnotationChange(page + 1, null, "Annotation", modification);
        }
        Object label = null;
        IAnnotationDesignerRegistry annotationDesigners = AnnotationDesignerRegistry.get();
        if (annotationDesigners != null && (designer = annotationDesigners.lookupAnnotationDesigner(annotation.cosGetSubtype())) != null) {
            label = designer.getAnnotationLabel(annotation);
        }
        if (label == null) {
            label = annotation.getSubtypeLabel() + " Annotation";
        }
        if (annotation.isWidgetAnnotation()) {
            PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
            PDAcroFormField field = widget.getAcroFormField();
            String fieldName = field == null ? widget.getName() : field.getQualifiedName();
            label = (String)label + " '" + fieldName + "'";
            String type = FormChangeType.of(field);
            return new WidgetChange(page + 1, type, (String)label, modification);
        }
        String type = null;
        return new AnnotationChange(page + 1, type, (String)label, modification);
    }

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        PDDocument doc = PDDocument.createFromCos((COSDocument)context.getBaseDocument());
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        this.identifyChange(baseObject, newObject, context, (PDPageNode)doc.getPageTree(), changes);
        return changes;
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, COSArray annotations, int page) throws IOException, COSLoadException {
        COSIndirectObject currentNodeRef = annotations.getIndirectObject();
        if (currentNodeRef == baseObject) {
            return this.compareAnnotations(baseObject, newObject, context, page);
        }
        for (COSObject cosAnnotation : annotations) {
            PDAnnotation annotation = (PDAnnotation)PDAnnotation.META.createFromCos(cosAnnotation);
            List<IDocumentChange> result = this.identifyChange(baseObject, newObject, context, annotation, page);
            if (result.isEmpty()) continue;
            return result;
        }
        return Collections.emptyList();
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, PDAnnotation annotation, int page) throws IOException, COSLoadException {
        COSIndirectObject currentNodeRef = annotation.cosGetObject().getIndirectObject();
        if (currentNodeRef == baseObject) {
            return this.compareAnnotation((COSDocumentElement)baseObject, (COSDocumentElement)newObject, context, page).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, PDPage page) throws IOException, COSLoadException {
        COSIndirectObject currentNodeRef = page.cosGetObject().getIndirectObject();
        if (currentNodeRef == baseObject) {
            return this.comparePage(baseObject, newObject, context);
        }
        COSArray annotations = page.cosGetDict().get(PDPage.DK_Annots).asArray();
        if (annotations != null) {
            return this.identifyChange(baseObject, newObject, context, annotations, page.getNodeIndex());
        }
        return Collections.emptyList();
    }

    protected void identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, PDPageNode pageNode, List<IDocumentChange> changes) throws IOException, COSLoadException {
        if (pageNode.isPage()) {
            changes.addAll(this.identifyChange(baseObject, newObject, context, (PDPage)pageNode));
        } else {
            COSIndirectObject currentNodeRef = pageNode.cosGetObject().getIndirectObject();
            if (currentNodeRef == baseObject) {
                changes.addAll(this.comparePageTree(baseObject, newObject, context));
            } else {
                PDPageTree pageTree = (PDPageTree)pageNode;
                for (PDPageNode child : pageTree.getKids()) {
                    this.identifyChange(baseObject, newObject, context, child, changes);
                }
            }
        }
    }

    protected static class AnnotationResult {
        protected List<IDocumentChange> changes;
        protected boolean processed;

        public AnnotationResult(List<IDocumentChange> changes, boolean processed) {
            this.changes = changes;
            this.processed = processed;
        }
    }
}

