/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDSS;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.signature.change.IgnorableChange;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DSSChangeIdentifier
implements IChangeIdentifier {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected List<IDocumentChange> basicCompareDSS(COSIndirectObject baseObject, COSDictionary baseDict, COSDictionary newDict, IChangeIdentifierContext context) throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageDSSChanged", new Object[]{baseObject.getKey()})));
        HistoryTools.compareDictionary(baseDict, newDict, (key, baseEntry, newEntry) -> {
            if (PDDSS.DK_CRLs.equals((Object)key) || PDDSS.DK_OCSPs.equals((Object)key) || PDDSS.DK_Certs.equals((Object)key) || PDDSS.DK_VRI.equals((Object)key)) {
                HistoryTools.setProcessed(context, baseEntry, newEntry);
            }
        });
        return changes;
    }

    protected List<IDocumentChange> compareAny(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageDSSChanged", new Object[]{baseObject.getKey()})));
        return changes;
    }

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        PDDocument doc = PDDocument.createFromCos((COSDocument)context.getBaseDocument());
        PDDSS dss = doc.getDSS();
        if (dss == null) {
            return Collections.emptyList();
        }
        return this.identifyChange(baseObject, newObject, context, doc.getDSS());
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, PDDSS dss) throws IOException, COSLoadException {
        COSIndirectObject currentNodeRef = dss.cosGetObject().getIndirectObject();
        if (currentNodeRef == baseObject) {
            return this.compareAny(baseObject, newObject, context);
        }
        COSIndirectObject currentRef = dss.cosGetField(PDDSS.DK_CRLs).getIndirectObject();
        if (currentRef == baseObject) {
            return this.compareAny(baseObject, newObject, context);
        }
        currentRef = dss.cosGetField(PDDSS.DK_OCSPs).getIndirectObject();
        if (currentRef == baseObject) {
            return this.compareAny(baseObject, newObject, context);
        }
        currentRef = dss.cosGetField(PDDSS.DK_Certs).getIndirectObject();
        if (currentRef == baseObject) {
            return this.compareAny(baseObject, newObject, context);
        }
        currentRef = dss.cosGetField(PDDSS.DK_VRI).getIndirectObject();
        if (currentRef == baseObject) {
            return this.compareAny(baseObject, newObject, context);
        }
        return Collections.emptyList();
    }
}

